/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Map;
import org.jboss.logmanager.FastCopyHashMap;

public final class MDC {
    private static final Holder mdc = new Holder();

    private MDC() {
    }

    public static String get(String key) {
        Object value = MDC.getObject(key);
        return value == null ? null : value.toString();
    }

    public static Object getObject(String key) {
        return ((FastCopyHashMap)mdc.get()).get(key);
    }

    public static String put(String key, String value) {
        Object oldValue = MDC.putObject(key, value);
        return oldValue == null ? null : oldValue.toString();
    }

    public static Object putObject(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        return ((FastCopyHashMap)mdc.get()).put(key, value);
    }

    public static String remove(String key) {
        Object oldValue = MDC.removeObject(key);
        return oldValue == null ? null : oldValue.toString();
    }

    public static Object removeObject(String key) {
        return ((FastCopyHashMap)mdc.get()).remove(key);
    }

    public static Map<String, String> copy() {
        return MDC.fastCopy();
    }

    static FastCopyHashMap<String, String> fastCopy() {
        FastCopyHashMap<String, String> result = new FastCopyHashMap<String, String>();
        for (Map.Entry entry : ((FastCopyHashMap)mdc.get()).entrySet()) {
            result.put((String)entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    public static Map<String, Object> copyObject() {
        return MDC.fastCopyObject();
    }

    static FastCopyHashMap<String, Object> fastCopyObject() {
        return ((FastCopyHashMap)mdc.get()).clone();
    }

    public static void clear() {
        ((FastCopyHashMap)mdc.get()).clear();
    }

    private static final class Holder
    extends InheritableThreadLocal<FastCopyHashMap<String, Object>> {
        private Holder() {
        }

        @Override
        protected FastCopyHashMap<String, Object> childValue(FastCopyHashMap<String, Object> parentValue) {
            return new FastCopyHashMap<String, Object>(parentValue);
        }

        @Override
        protected FastCopyHashMap<String, Object> initialValue() {
            return new FastCopyHashMap<String, Object>();
        }
    }
}

