/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Cause;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MethodParameterValidator
implements ElementValidator {
    private static final String ERROR_MESSAGE = "The number of parameters, minus the cause parameter, must match all match all methods with the same name. Method %s accepts %d parameters and method %s accepts %d parameters.";

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        HashSet<Name> methodNames = new HashSet<Name>();
        for (ExecutableElement method : elementMethods) {
            if (methodNames.add(method.getSimpleName())) {
                Collection<ExecutableElement> likeMethods = this.findByName(elementMethods, method.getSimpleName());
                int paramCount1 = method.getParameters().size() - (this.hasCause(method.getParameters()) ? 1 : 0);
                for (ExecutableElement executableElement : likeMethods) {
                    int paramCount2 = executableElement.getParameters().size() - (this.hasCause(executableElement.getParameters()) ? 1 : 0);
                    if (paramCount1 == paramCount2) continue;
                    errorMessages.add(new ValidationErrorMessage(executableElement, String.format(ERROR_MESSAGE, method.toString(), method.getParameters().size(), executableElement.toString(), executableElement.getParameters().size())));
                }
            }
            boolean invalid = false;
            Cause ogCause = null;
            for (VariableElement variableElement : method.getParameters()) {
                Cause cause = variableElement.getAnnotation(Cause.class);
                boolean bl = invalid = ogCause != null && cause != null;
                if (invalid) {
                    errorMessages.add(new ValidationErrorMessage(variableElement, "Only one cause parameter allowed per method."));
                }
                ogCause = cause;
            }
        }
        return errorMessages;
    }

    private Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!((Object)methodName).equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    private boolean hasCause(Collection<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            if (variableElement.getAnnotation(Cause.class) == null) continue;
            return true;
        }
        return false;
    }
}

