/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class BundleReturnTypeValidator
implements ElementValidator {
    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        if (ElementHelper.isAnnotatedWith(element, MessageBundle.class)) {
            for (ExecutableElement method : elementMethods) {
                String message;
                try {
                    Class<String> returnClass = Class.forName(((Object)method.getReturnType()).toString());
                    if (Throwable.class.isAssignableFrom(returnClass) || returnClass.isAssignableFrom(String.class)) continue;
                    message = String.format("Message bundle %s has a method with invalid return type, method %s have return type of type %s", element, method, returnClass);
                    errorMessages.add(new ValidationErrorMessage(method, message));
                }
                catch (ClassNotFoundException e) {
                    message = String.format("Return type %s for method %s is not in the classpath", method.getReturnType(), method);
                    errorMessages.add(new ValidationErrorMessage(method, message));
                }
            }
        }
        return errorMessages;
    }
}

