/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.logging.AbstractTool;
import org.jboss.logging.model.ClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MessageBundleTranslator;
import org.jboss.logging.model.MessageLoggerTranslator;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.util.TransformationHelper;
import org.jboss.logging.util.TranslationHelper;

@SupportedOptions(value={"translationFilesPath"})
public final class TranslationClassGenerator
extends AbstractTool {
    public static final String TRANSLATION_FILES_PATH_OPTION = "translationFilesPath";
    private static final String SOURCE_FILE_EXTENSION = ".java";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String TRANSLATION_FILE_EXTENSION_PATTERN = ".i18n_[a-z]*(_[A-Z]*){0,2}\\.properties";
    private final String translationFilesPath;

    public TranslationClassGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        Map<String, String> options = processingEnv.getOptions();
        this.translationFilesPath = options.get(TRANSLATION_FILES_PATH_OPTION);
    }

    @Override
    public void processTypeElement(TypeElement annotation, TypeElement element, Collection<ExecutableElement> methods) {
        PackageElement packageElement = this.elementUtils().getPackageOf(element);
        String packageName = packageElement.getQualifiedName().toString();
        String primaryClassName = ElementHelper.getPrimaryClassName(element);
        primaryClassName = TransformationHelper.toQualifiedClassName(packageName, primaryClassName);
        String primaryClassNamePrefix = ElementHelper.getPrimaryClassNamePrefix(element);
        String interfaceName = element.getSimpleName().toString();
        Map<String, String> elementTranslations = ElementHelper.getAllMessageMethods(methods);
        try {
            String packagePath;
            if (this.translationFilesPath != null) {
                packagePath = this.translationFilesPath + packageName.replaceAll("\\.", FILE_SEPARATOR);
            } else {
                FileObject fObj = this.filer().getResource(StandardLocation.CLASS_OUTPUT, packageName, interfaceName);
                packagePath = fObj.toUri().getPath().replaceAll(Pattern.quote(interfaceName), "");
            }
            File dir = new File(packagePath);
            File[] files = dir.listFiles(new TranslationFileFilter(primaryClassNamePrefix));
            if (files != null) {
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return Integer.signum(o1.getName().length() - o2.getName().length());
                    }
                });
                for (File file : files) {
                    String classNameSuffix = TranslationHelper.getTranslationClassNameSuffix(file.getName());
                    String qualifiedClassName = primaryClassName.concat(classNameSuffix);
                    Map<String, String> translations = this.validateTranslationMessages(elementTranslations, file);
                    this.generateSourceFile(primaryClassName, qualifiedClassName, translations);
                }
            }
        }
        catch (IOException e) {
            this.logger().error(e, "Cannot read %s package files", packageName);
        }
    }

    private Map<String, String> validateTranslationMessages(Map<String, String> elementTranslations, File file) {
        HashMap<String, String> validTranslations = new HashMap<String, String>();
        try {
            Properties translations = new Properties();
            translations.load(new FileInputStream(file));
            for (String key : translations.stringPropertyNames()) {
                if (elementTranslations.containsKey(key)) {
                    String message = translations.getProperty(key);
                    if (!message.trim().isEmpty()) {
                        validTranslations.put(key, translations.getProperty(key));
                        continue;
                    }
                    this.logger().warn("The translation message with key %s is ignored because value is empty or contains only whitespace", key);
                    continue;
                }
                this.logger().warn("The translation message with key %s have no corresponding method.", key);
            }
        }
        catch (IOException e) {
            this.logger().error(e, "Cannot read the % translation file", file.getName());
        }
        return validTranslations;
    }

    private void generateSourceFile(String primaryClassName, String generatedClassName, Map<String, String> translations) {
        this.logger().note("Generating %s translation class", generatedClassName);
        try {
            FileObject fObject;
            String pathName;
            File file;
            String superClassName = TranslationHelper.getEnclosingTranslationClassName(generatedClassName);
            String packageName = TransformationHelper.toPackage(superClassName);
            String simpleClassName = TransformationHelper.toSimpleClassName(superClassName);
            if (!superClassName.equals(primaryClassName) && !(file = new File(pathName = (fObject = this.filer().getResource(StandardLocation.SOURCE_OUTPUT, packageName, simpleClassName)).toUri().getPath().replaceAll(Pattern.quote(simpleClassName), ""), simpleClassName.concat(SOURCE_FILE_EXTENSION))).exists()) {
                this.generateSourceFile(primaryClassName, superClassName, Collections.EMPTY_MAP);
            }
            ClassModel classModel = primaryClassName.contains(ImplementationType.BUNDLE.toString()) ? new MessageBundleTranslator(generatedClassName, superClassName, translations) : new MessageLoggerTranslator(generatedClassName, superClassName, translations);
            classModel.create(this.filer().createSourceFile(classModel.getClassName(), new Element[0]));
        }
        catch (Exception e) {
            this.logger().error(e, "Cannot generate %s source file", generatedClassName);
        }
    }

    private class TranslationFileFilter
    implements FilenameFilter {
        private final String className;

        public TranslationFileFilter(String className) {
            this.className = className;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean isGenerated = name.endsWith(".i18n_locale_COUNTRY_VARIANT.properties");
            boolean isTranslationFile = name.matches(Pattern.quote(this.className) + TranslationClassGenerator.TRANSLATION_FILE_EXTENSION_PATTERN);
            return !isGenerated && isTranslationFile;
        }
    }
}

