/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.jboss.logging.Annotations;
import org.jboss.logging.validation.ValidationErrorMessage;
import org.jboss.logging.validation.ValidationMessage;
import org.jboss.logging.validation.validator.AbstractValidator;

public class MessageIdValidator
extends AbstractValidator {
    private static final String ERROR_MESSAGE = "Message id %s is not unique for method %s with project code %s.";
    private final Map<String, IdDescriptor> messageIdMap = new HashMap<String, IdDescriptor>();

    public MessageIdValidator(Annotations annotations, Types typeUtil) {
        super(annotations, typeUtil);
    }

    @Override
    public Collection<ValidationMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (ExecutableElement method : elementMethods) {
            int messageId;
            if (!this.annotations.hasMessageId(method)) continue;
            String projectCode = this.annotations.projectCode(element);
            String key = this.createKey(projectCode, messageId = this.annotations.messageId(method));
            if (this.messageIdMap.containsKey(key)) {
                IdDescriptor idDesc = this.messageIdMap.get(key);
                if (!idDesc.error) {
                    messages.add(ValidationErrorMessage.of(idDesc.method, ERROR_MESSAGE, messageId, idDesc.method, projectCode));
                    idDesc.error = true;
                }
                messages.add(ValidationErrorMessage.of(method, ERROR_MESSAGE, messageId, method, projectCode));
                continue;
            }
            this.messageIdMap.put(key, new IdDescriptor(messageId, method));
        }
        return messages;
    }

    private String createKey(String projectCode, int messageId) {
        StringBuilder result = new StringBuilder();
        result.append(projectCode);
        result.append(":");
        result.append(messageId);
        return result.toString();
    }

    private static class IdDescriptor {
        final int id;
        final ExecutableElement method;
        boolean error = false;

        public IdDescriptor(int id, ExecutableElement method) {
            this.id = id;
            this.method = method;
        }
    }
}

