/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.GenericAnnotationResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.annotations.DeploymentUnitClassPath;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEnvironmentDeployer
extends AbstractOptionalVFSRealDeployer<Module> {
    private boolean forceAnnotations;
    private boolean keepAnnotations;
    private boolean checkInterfaces;

    public AnnotationEnvironmentDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setOutput(AnnotationEnvironment.class);
        this.checkInterfaces = true;
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.keepAnnotations = keepAnnotations;
    }

    public void setCheckInterfaces(boolean checkInterfaces) {
        this.checkInterfaces = checkInterfaces;
    }

    protected GenericAnnotationResourceVisitor createGenericAnnotationResourceVisitor(DeploymentUnit unit, ClassPool pool, ClassLoader classLoader) {
        GenericAnnotationResourceVisitor visitor = new GenericAnnotationResourceVisitor(pool, classLoader);
        visitor.setForceAnnotations(this.forceAnnotations);
        visitor.setKeepAnnotations(this.keepAnnotations);
        visitor.setCheckInterfaces(this.checkInterfaces);
        return visitor;
    }

    @Deprecated
    protected ClassPool createClassPool(ClassLoader classLoader) {
        ClassPool pool = new ClassPool();
        LoaderClassPath classPath = new LoaderClassPath(classLoader);
        pool.insertClassPath((ClassPath)classPath);
        return pool;
    }

    protected ClassPool createClassPool(VFSDeploymentUnit unit) {
        ClassPool pool = new ClassPool();
        DeploymentUnitClassPath deploymentPath = new DeploymentUnitClassPath(unit);
        pool.appendClassPath((ClassPath)deploymentPath);
        LoaderClassPath classPath = new LoaderClassPath(unit.getClassLoader());
        pool.appendClassPath((ClassPath)classPath);
        return pool;
    }

    protected void visitModule(VFSDeploymentUnit unit, Module module, GenericAnnotationResourceVisitor visitor) throws DeploymentException {
        try {
            module.visit((ResourceVisitor)visitor, visitor.getFilter(), null, this.getUrls(unit));
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Exception visiting module", (Throwable)e);
        }
    }

    protected URL[] getUrls(VFSDeploymentUnit unit) throws Exception {
        List classpath = unit.getClassPath();
        if (classpath != null && !classpath.isEmpty()) {
            ArrayList<URL> urls = new ArrayList<URL>();
            VirtualFile root = unit.getRoot();
            Iterator i$ = classpath.iterator();
            while (i$.hasNext()) {
                VirtualFile cp;
                VirtualFile check;
                for (check = cp = (VirtualFile)i$.next(); check != null && !check.equals((Object)root); check = check.getParent()) {
                }
                if (check == null) continue;
                urls.add(cp.toURL());
            }
            if (!urls.isEmpty()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Explicit urls: " + urls));
                }
                return urls.toArray(new URL[urls.size()]);
            }
        }
        return new URL[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(VFSDeploymentUnit unit, Module module) throws DeploymentException {
        if (module == null) {
            for (VFSDeploymentUnit parent = unit.getParent(); parent != null && module == null; parent = parent.getParent()) {
                module = (Module)parent.getAttachment(Module.class);
            }
            if (module == null) {
                throw new IllegalArgumentException("No module in deployment unit's hierarchy: " + unit.getName());
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating AnnotationEnvironment for " + unit.getName() + ", module: " + module + ", force annotations: " + this.forceAnnotations));
        }
        ClassLoader classLoader = unit.getClassLoader();
        ClassPool pool = this.createClassPool(unit);
        GenericAnnotationResourceVisitor visitor = this.createGenericAnnotationResourceVisitor((DeploymentUnit)unit, pool, classLoader);
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.visitModule(unit, module, visitor);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        unit.addAttachment(AnnotationEnvironment.class, (Object)visitor.getEnv());
    }
}

