/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.system.ClassLoaderSystemBuilder;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderSystemMBean;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
import org.jboss.logging.Logger;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderSystem
extends BaseClassLoaderSystem
implements ClassLoaderSystemMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(ClassLoaderSystem.class);
    public static final String DEFAULT_DOMAIN_NAME = "DefaultDomain";
    private static final ClassLoaderSystemBuilder builder = new ClassLoaderSystemBuilder();
    private ClassLoaderDomain defaultDomain;
    private Map<String, ClassLoaderDomain> registeredDomains = new HashMap<String, ClassLoaderDomain>();
    private Translator translator;
    private boolean shutdown = false;
    private MBeanServer mbeanServer;
    private ObjectName objectName;

    public static final ClassLoaderSystem getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        return builder.get();
    }

    public synchronized ClassLoaderDomain getDefaultDomain() {
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        this.defaultDomain = this.registeredDomains.get(DEFAULT_DOMAIN_NAME);
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        this.defaultDomain = this.createDefaultDomain();
        this.internalRegisterDomain(DEFAULT_DOMAIN_NAME, this.defaultDomain);
        return this.defaultDomain;
    }

    protected ClassLoaderDomain createDefaultDomain() {
        return this.createDomain(DEFAULT_DOMAIN_NAME);
    }

    protected abstract ClassLoaderDomain createDomain(String var1);

    public ClassLoaderDomain createAndRegisterDomain(String name) {
        return this.createAndRegisterDomain(name, ParentPolicy.BEFORE, null);
    }

    public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy) {
        return this.createAndRegisterDomain(name, parentPolicy, null);
    }

    public ClassLoaderDomain createAndRegisterDomain(String name, ParentPolicy parentPolicy, Loader parent) {
        ClassLoaderDomain result = this.createDomain(name);
        result.setParentPolicy(parentPolicy);
        result.setParent(parent);
        this.registerDomain(result);
        return result;
    }

    public synchronized ClassLoaderDomain getDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        ClassLoaderDomain result = this.registeredDomains.get(name);
        if (result == null && DEFAULT_DOMAIN_NAME.equals(name)) {
            result = this.getDefaultDomain();
        }
        return result;
    }

    public boolean isRegistered(String name) {
        return this.getDomain(name) != null;
    }

    public boolean isDomainRegistered(ClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        return this.getDomain(domain.getName()) == domain;
    }

    public synchronized void registerDomain(ClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        String name = domain.getName();
        if (this.isRegistered(name)) {
            throw new IllegalStateException("A domain is already registered with name " + name);
        }
        this.internalRegisterDomain(name, domain);
    }

    private void internalRegisterDomain(String name, ClassLoaderDomain domain) {
        if (this.shutdown) {
            throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
        }
        this.registeredDomains.put(name, domain);
        super.registerDomain(domain);
        this.registerDomainMBean(domain);
        log.debug((Object)(this + " registered domain=" + domain.toLongString()));
    }

    public synchronized void unregisterDomain(ClassLoaderDomain domain) {
        if (!this.isDomainRegistered(domain)) {
            throw new IllegalStateException("Domain is not registered " + domain);
        }
        if (DEFAULT_DOMAIN_NAME.equals(domain.getName())) {
            throw new IllegalArgumentException("Cannot unregister the default domain");
        }
        this.internalUnregisterDomain(domain);
    }

    private synchronized void internalUnregisterDomain(ClassLoaderDomain domain) {
        this.unregisterDomainMBean(domain);
        this.registeredDomains.remove(domain.getName());
        super.unregisterDomain(domain);
        log.debug((Object)(this + " unregistered domain=" + domain.toLongString()));
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderPolicy policy) {
        return this.registerClassLoaderPolicy(this.getDefaultDomain(), policy);
    }

    public ClassLoader registerClassLoaderPolicy(String domainName, ClassLoaderPolicy policy) {
        return this.registerClassLoaderPolicy(domainName, ParentPolicy.BEFORE, (Loader)null, policy);
    }

    public ClassLoader registerClassLoaderPolicy(String domainName, ParentPolicy parentPolicy, ClassLoaderPolicy policy) {
        return this.registerClassLoaderPolicy(domainName, parentPolicy, (Loader)null, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader registerClassLoaderPolicy(String domainName, ParentPolicy parentPolicy, String parentDomainName, ClassLoaderPolicy policy) {
        ClassLoaderDomain domain;
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        if (parentPolicy == null) {
            throw new IllegalArgumentException("Null parent policy");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null classloader policy");
        }
        ClassLoaderSystem classLoaderSystem = this;
        synchronized (classLoaderSystem) {
            domain = this.getDomain(domainName);
            if (domain == null) {
                if (parentDomainName != null) {
                    ClassLoaderDomain parentDomain = this.getDomain(parentDomainName);
                    if (parentDomain == null) {
                        throw new IllegalStateException("Parent domain: " + parentDomainName + " does not exist.");
                    }
                    domain = this.createAndRegisterDomain(domainName, parentPolicy, parentDomain);
                } else {
                    domain = this.createAndRegisterDomain(domainName, parentPolicy);
                }
            }
        }
        return this.registerClassLoaderPolicy(domain, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader registerClassLoaderPolicy(String domainName, ParentPolicy parentPolicy, Loader parent, ClassLoaderPolicy policy) {
        ClassLoaderDomain domain;
        if (domainName == null) {
            throw new IllegalArgumentException("Null domain name");
        }
        if (parentPolicy == null) {
            throw new IllegalArgumentException("Null parent policy");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null classloader policy");
        }
        ClassLoaderSystem classLoaderSystem = this;
        synchronized (classLoaderSystem) {
            domain = this.getDomain(domainName);
            if (domain == null) {
                domain = this.createAndRegisterDomain(domainName, parentPolicy, parent);
            }
        }
        return this.registerClassLoaderPolicy(domain, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader registerClassLoaderPolicy(ClassLoaderDomain domain, ClassLoaderPolicy policy) {
        if (!this.isDomainRegistered(domain)) {
            throw new IllegalStateException("Domain is not registered: " + domain);
        }
        ClassLoaderSystem classLoaderSystem = this;
        synchronized (classLoaderSystem) {
            if (this.shutdown) {
                throw new IllegalStateException("The classloader system is shutdown: " + this.toLongString());
            }
        }
        return super.registerClassLoaderPolicy(domain, policy);
    }

    @Override
    public void unregisterClassLoaderPolicy(ClassLoaderPolicy policy) {
        super.unregisterClassLoaderPolicy(policy);
    }

    @Override
    public void unregisterClassLoader(ClassLoader classLoader) {
        super.unregisterClassLoader(classLoader);
    }

    public synchronized void shutdown() {
        ArrayList<ClassLoaderDomain> domains;
        Iterator iterator;
        if (this.shutdown) {
            return;
        }
        log.debug((Object)(this.toLongString() + " SHUTDOWN!"));
        this.shutdown = true;
        while ((iterator = (domains = new ArrayList<ClassLoaderDomain>(this.registeredDomains.values())).iterator()).hasNext()) {
            while (iterator.hasNext()) {
                ClassLoaderDomain domain = (ClassLoaderDomain)iterator.next();
                this.internalUnregisterDomain(domain);
            }
        }
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        log.debug((Object)(this + " set translator to " + translator));
        this.translator = translator;
    }

    @Override
    protected byte[] transform(ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        if (this.translator != null) {
            return this.translator.transform(classLoader, className, null, protectionDomain, byteCode);
        }
        return super.transform(classLoader, className, byteCode, protectionDomain);
    }

    @Override
    protected void afterUnregisterClassLoader(ClassLoader classLoader) {
        try {
            if (this.translator != null) {
                this.translator.unregisterClassLoader(classLoader);
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Error unregistering classloader from translator " + classLoader), t);
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        this.objectName = name;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            for (ClassLoaderDomain domain : this.registeredDomains.values()) {
                this.registerDomainMBean(domain);
            }
        } else {
            this.postDeregister();
        }
    }

    @Override
    public void preDeregister() throws Exception {
        for (ClassLoaderDomain domain : this.registeredDomains.values()) {
            this.unregisterDomainMBean(domain);
        }
    }

    @Override
    public void postDeregister() {
        this.mbeanServer = null;
        this.objectName = null;
    }

    @Override
    public Set<String> getDomainNames() {
        return this.registeredDomains.keySet();
    }

    @Override
    public Set<ObjectName> getDomains() {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ClassLoaderDomain domain : this.registeredDomains.values()) {
            names.add(domain.getObjectName());
        }
        return names;
    }

    protected ObjectName getObjectName(ClassLoaderDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("domain", "\"" + domain.getName() + "\"");
        properties.put("system", "" + System.identityHashCode(this));
        try {
            return ObjectName.getInstance("jboss.classloader", properties);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    protected void registerDomainMBean(ClassLoaderDomain domain) {
        if (this.mbeanServer == null) {
            return;
        }
        try {
            ObjectName name = this.getObjectName(domain);
            this.mbeanServer.registerMBean(domain, name);
        }
        catch (Exception e) {
            log.warn((Object)("Error registering domain: " + domain), (Throwable)e);
        }
    }

    protected void unregisterDomainMBean(ClassLoaderDomain domain) {
        if (this.mbeanServer == null) {
            return;
        }
        try {
            ObjectName name = this.getObjectName(domain);
            this.mbeanServer.unregisterMBean(name);
        }
        catch (Exception e) {
            log.warn((Object)("Error unregistering domain: " + domain), (Throwable)e);
        }
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        if (this.shutdown) {
            builder.append("SHUTDOWN! ");
        }
        super.toLongString(builder);
    }
}

