/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.jboss.as.plugin.common.DeploymentExecutionException;
import org.jboss.as.plugin.common.DeploymentFailureException;
import org.jboss.as.plugin.common.Operations;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.as.plugin.deployment.domain.Domain;
import org.jboss.dmr.ModelNode;

public class DomainDeployment
implements Deployment {
    private final File content;
    private final DomainClient client;
    private final Domain domain;
    private final String name;
    private final Deployment.Type type;

    public DomainDeployment(DomainClient client, Domain domain, File content, String name, Deployment.Type type) {
        this.content = content;
        this.client = client;
        this.domain = domain;
        this.name = name == null ? content.getName() : name;
        this.type = type;
    }

    public static DomainDeployment create(DomainClient client, Domain domain, File content, String name, Deployment.Type type) {
        return new DomainDeployment(client, domain, content, name, type);
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException, DuplicateDeploymentNameException, DeploymentFailureException {
        boolean deploymentExists = this.exists();
        RemoveDeploymentPlanBuilder completeBuilder = null;
        switch (this.type) {
            case DEPLOY: {
                completeBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case FORCE_DEPLOY: {
                if (deploymentExists) {
                    completeBuilder = builder.replace(this.name, this.content);
                    break;
                }
                completeBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case REDEPLOY: {
                completeBuilder = builder.replace(this.name, this.content);
                break;
            }
            case UNDEPLOY: {
                completeBuilder = builder.undeploy(this.name).andRemoveUndeployed();
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                if (deploymentExists) {
                    completeBuilder = builder.undeploy(this.name).andRemoveUndeployed();
                    break;
                }
                return null;
            }
        }
        if (completeBuilder != null) {
            ServerGroupDeploymentPlanBuilder groupDeploymentBuilder = null;
            for (String serverGroupName : this.domain.getServerGroups()) {
                groupDeploymentBuilder = groupDeploymentBuilder == null ? completeBuilder.toServerGroup(serverGroupName) : groupDeploymentBuilder.toServerGroup(serverGroupName);
            }
            if (groupDeploymentBuilder == null) {
                throw new DeploymentFailureException("No server groups were defined for the deployment.");
            }
            return groupDeploymentBuilder.withRollback().build();
        }
        throw new IllegalStateException(String.format("Invalid type '%s' for deployment", new Object[]{this.type}));
    }

    @Override
    public Deployment.Status execute() throws DeploymentExecutionException, DeploymentFailureException {
        try {
            this.validate();
            DomainDeploymentManager manager = this.client.getDeploymentManager();
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null) {
                this.executePlan(manager, plan);
            }
        }
        catch (DeploymentFailureException e) {
            throw e;
        }
        catch (DeploymentExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentExecutionException(e, "Error executing %s", new Object[]{this.type});
        }
        return Deployment.Status.SUCCESS;
    }

    void validate() throws DeploymentFailureException {
        Map statuses = this.client.getServerStatuses();
        List<String> serverGroups = this.domain.getServerGroups();
        for (String serverGroup : serverGroups) {
            boolean notFound = true;
            for (ServerIdentity serverId : statuses.keySet()) {
                if (!serverGroup.equals(serverId.getServerGroupName())) continue;
                ServerStatus currentStatus = (ServerStatus)statuses.get(serverId);
                if (currentStatus != ServerStatus.STARTED) {
                    throw new DeploymentFailureException("Status of server group '%s' is '%s', but is required to be '%s'.", serverGroup, currentStatus, ServerStatus.STARTED);
                }
                notFound = false;
                break;
            }
            if (!notFound) continue;
            throw new DeploymentFailureException("Server group '%s' does not exist on the server.", serverGroup);
        }
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private void executePlan(DomainDeploymentManager manager, DeploymentPlan plan) throws DeploymentExecutionException, ExecutionException, InterruptedException {
        if (plan.getDeploymentActions().size() > 0) {
            DeploymentPlanResult planResult = (DeploymentPlanResult)manager.execute(plan).get();
            Map actionResults = planResult.getDeploymentActionResults();
            for (UUID uuid : actionResults.keySet()) {
                Map groupDeploymentActionResults = ((DeploymentActionResult)actionResults.get(uuid)).getResultsByServerGroup();
                for (String serverGroup2 : groupDeploymentActionResults.keySet()) {
                    Map serverUpdateResults = ((ServerGroupDeploymentActionResult)groupDeploymentActionResults.get(serverGroup2)).getResultByServer();
                    for (String server : serverUpdateResults.keySet()) {
                        Throwable t = ((ServerUpdateResult)serverUpdateResults.get(server)).getFailureResult();
                        if (t == null) continue;
                        throw new DeploymentExecutionException(t, "Error executing %s", new Object[]{this.type});
                    }
                }
            }
        }
    }

    private boolean exists() {
        block4: {
            ModelNode op = Operations.createListDeploymentsOperation();
            try {
                ModelNode result = this.client.execute(op);
                String deploymentName = this.name;
                if (Operations.successful(result)) {
                    List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                    for (ModelNode n : deployments) {
                        if (!n.asString().equals(deploymentName)) continue;
                        return true;
                    }
                    break block4;
                }
                throw new IllegalStateException(Operations.getFailureDescription(result));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        return false;
    }
}

