/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;

public class ExternalModuleSpecService
implements Service<ModuleSpec> {
    private final ModuleIdentifier moduleIdentifier;
    private final File file;
    private volatile ModuleSpec moduleSpec;
    private volatile JarFile jarFile;

    public ExternalModuleSpecService(ModuleIdentifier moduleIdentifier, File file) {
        this.moduleIdentifier = moduleIdentifier;
        this.file = file;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            this.jarFile = new JarFile(this.file);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)this.moduleIdentifier);
        ExternalModuleSpecService.addResourceRoot(specBuilder, this.jarFile);
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)ModuleIdentifier.create((String)"javaee.api")));
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        this.moduleSpec = specBuilder.create();
    }

    public synchronized void stop(StopContext context) {
        VFSUtils.safeClose((ZipFile)this.jarFile);
        this.jarFile = null;
        this.moduleSpec = null;
    }

    public ModuleSpec getValue() throws IllegalStateException, IllegalArgumentException {
        return this.moduleSpec;
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, JarFile file) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)file.getName(), (JarFile)file)));
    }
}

