/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class OSGiFrameworkPropertyAdd
extends AbstractAddStepHandler {
    static final OSGiFrameworkPropertyAdd INSTANCE = new OSGiFrameworkPropertyAdd();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("framework.property.add"));
            node.get(new String[]{"request-properties", "value", "description"}).set(resbundle.getString("framework.property.value"));
            node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "value", "required"}).set(true);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiFrameworkPropertyAdd() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER || context.getType() == OperationContext.Type.HOST;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("value").set(operation.get("value"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String propName = operation.get("address").asObject().get("property").asString();
        String propValue = model.get("value").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.setProperty(propName, propValue);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String propName = operation.get("address").asObject().get("property").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.setProperty(propName, null);
        }
    }
}

