/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.process.ProcessMessages;

enum CommandLineArgument {
    ADMIN_ONLY{

        @Override
        public String argument() {
            return "--admin-only";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argAdminOnly();
        }
    }
    ,
    PUBLIC_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPublicBindAddress();
        }
    }
    ,
    LEGACY_PUBLIC_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <value>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPublicBindAddress();
        }
    }
    ,
    INTERFACE_BIND_ADDRESS{

        @Override
        public String argument() {
            return "-b";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<interface>=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterfaceBindAddress();
        }
    }
    ,
    BACKUP{

        @Override
        public String argument() {
            return "--backup";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argBackup();
        }
    }
    ,
    SHORT_DOMAIN_CONFIG{

        @Override
        public String argument() {
            return "-c";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDomainConfig();
        }
    }
    ,
    LEGACY_SHORT_DOMAIN_CONFIG{

        @Override
        public String argument() {
            return "-c";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDomainConfig();
        }
    }
    ,
    CACHED_DC{

        @Override
        public String argument() {
            return "--cached-dc";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argCachedDc();
        }
    }
    ,
    SYSTEM_PROPERTY{

        @Override
        public String argument() {
            return "-D";
        }

        @Override
        public String argumentExample() {
            return String.format("%s<name>[=<value>]", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argSystem();
        }
    }
    ,
    DOMAIN_CONFIG{

        @Override
        public String argument() {
            return "--domain-config";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDomainConfig();
        }
    }
    ,
    SHORT_HELP{

        @Override
        public String argument() {
            return "-h";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHelp();
        }
    }
    ,
    HELP{

        @Override
        public String argument() {
            return "--help";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHelp();
        }
    }
    ,
    HOST_CONFIG{

        @Override
        public String argument() {
            return "--host-config";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<config>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argHostConfig();
        }
    }
    ,
    INTERPROCESS_HC_ADDRESS{

        @Override
        public String argument() {
            return "--interprocess-hc-address";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<address>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterProcessHcAddress();
        }
    }
    ,
    INTERPROCESS_HC_PORT{

        @Override
        public String argument() {
            return "--interprocess-hc-port";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<port>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argInterProcessHcPort();
        }
    }
    ,
    MASTER_ADDRESS{

        @Override
        public String argument() {
            return "--master-address";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<address>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argMasterAddress();
        }
    }
    ,
    MASTER_PORT{

        @Override
        public String argument() {
            return "--master-port";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<port>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argMasterPort();
        }
    }
    ,
    SHORT_PROPERTIES{

        @Override
        public String argument() {
            return "-P";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argProperties();
        }
    }
    ,
    LEGACY_SHORT_PROPERTIES{

        @Override
        public String argument() {
            return "-P";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <url>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argProperties();
        }
    }
    ,
    PROPERTIES{

        @Override
        public String argument() {
            return "--properties";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<url>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argProperties();
        }
    }
    ,
    PC_ADDRESS{

        @Override
        public String argument() {
            return "--pc-address";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<address>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPcAddress();
        }
    }
    ,
    PC_PORT{

        @Override
        public String argument() {
            return "--pc-port";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<port>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argPcPort();
        }
    }
    ,
    DEFAULT_MULTICAST_ADDRESS{

        @Override
        public String argument() {
            return "-u";
        }

        @Override
        public String argumentExample() {
            return String.format("%s=<value>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDefaultMulticastAddress();
        }
    }
    ,
    LEGACY_DEFAULT_MULTICAST_ADDRESS{

        @Override
        public String argument() {
            return "-u";
        }

        @Override
        public String argumentExample() {
            return String.format("%s <value>", this.argument());
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argDefaultMulticastAddress();
        }
    }
    ,
    LEGACY_SHORT_VERSION{

        @Override
        public String argument() {
            return "-V";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argVersion();
        }
    }
    ,
    SHORT_VERSION{

        @Override
        public String argument() {
            return "-v";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argVersion();
        }
    }
    ,
    VERSION{

        @Override
        public String argument() {
            return "--version";
        }

        @Override
        public String argumentExample() {
            return this.argument();
        }

        @Override
        public String instructions() {
            return ProcessMessages.MESSAGES.argVersion();
        }
    };

    private static String USAGE;
    static final String NEW_LINE;

    public abstract String argument();

    public abstract String argumentExample();

    public abstract String instructions();

    public String toString() {
        ArrayList<String> instructions = new ArrayList<String>();
        CommandLineArgument.segmentInstructions(this.instructions(), instructions);
        StringBuilder sb = new StringBuilder(String.format("    %-35s %s", this.argumentExample(), instructions.get(0)));
        for (int i = 1; i < instructions.size(); ++i) {
            sb.append(NEW_LINE);
            sb.append(String.format("%-40s%s", " ", instructions.get(i)));
        }
        sb.append(NEW_LINE);
        return sb.toString();
    }

    private static void segmentInstructions(String instructions, List<String> segments) {
        if (instructions.length() <= 40) {
            segments.add(instructions);
        } else {
            String testFragment = instructions.substring(0, 40);
            int lastSpace = testFragment.lastIndexOf(32);
            if (lastSpace < 0) {
                lastSpace = 39;
            }
            segments.add(instructions.substring(0, lastSpace + 1));
            CommandLineArgument.segmentInstructions(instructions.substring(lastSpace + 1), segments);
        }
    }

    public static void printUsage(PrintStream out) {
        out.print(CommandLineArgument.usage());
    }

    public static String usage() {
        if (USAGE == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProcessMessages.MESSAGES.argUsage()).append(NEW_LINE);
            for (CommandLineArgument arg : CommandLineArgument.values()) {
                sb.append(arg.toString()).append(NEW_LINE);
            }
            USAGE = sb.toString();
        }
        return USAGE;
    }

    static {
        NEW_LINE = String.format("%n", new Object[0]);
    }
}

