/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.Tools;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Setter;

public class SinglePropertyMapper
implements PropertyMapper,
SimpleMapperBuilder {
    private PropertyData propertyData;

    public SinglePropertyMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    public SinglePropertyMapper() {
    }

    @Override
    public void add(PropertyData propertyData) {
        if (this.propertyData != null) {
            throw new AuditException("Only one property can be added!");
        }
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        data.put(this.propertyData.getName(), newObj);
        return !Tools.objectsEqual(newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        Object value = data.get(this.propertyData.getName());
        if (value != null || !this.isPrimitive(setter, this.propertyData, obj.getClass())) {
            setter.set(obj, value, null);
        }
    }

    private boolean isPrimitive(Setter setter, PropertyData propertyData, Class<?> cls) {
        if (cls == null) {
            throw new HibernateException("No field found for property: " + propertyData.getName());
        }
        if (setter instanceof DirectPropertyAccessor.DirectSetter) {
            try {
                return cls.getDeclaredField(propertyData.getBeanName()).getType().isPrimitive();
            }
            catch (NoSuchFieldException e) {
                return this.isPrimitive(setter, propertyData, cls.getSuperclass());
            }
        }
        return setter.getMethod().getParameterTypes()[0].isPrimitive();
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

