/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.ExecutorProvider;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jgroups.Channel;
import org.jgroups.util.TopologyUUID;

public class EmbeddedCacheManagerConfigurationService
implements Service<EmbeddedCacheManagerConfiguration>,
EmbeddedCacheManagerConfiguration {
    private final String name;
    private final String defaultCache;
    private final Dependencies dependencies;
    private volatile GlobalConfiguration config;

    public static ServiceName getServiceName(String name) {
        return EmbeddedCacheManagerService.getServiceName(name).append(new String[]{"config"});
    }

    public static ServiceName getClassLoaderServiceName(String name) {
        return EmbeddedCacheManagerConfigurationService.getServiceName(name).append(new String[]{"loader"});
    }

    public EmbeddedCacheManagerConfigurationService(String name, String defaultCache, Dependencies dependencies) {
        this.name = name;
        this.defaultCache = defaultCache;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultCache() {
        return this.defaultCache;
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.config;
    }

    public EmbeddedCacheManagerConfiguration getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        Executor listenerExecutor;
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        ClassLoader loader = this.dependencies.getClassLoader();
        if (loader == null) {
            loader = EmbeddedCacheManagerConfiguration.class.getClassLoader();
        }
        builder.classLoader(loader);
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        TransportConfiguration transport = this.dependencies.getTransportConfiguration();
        TransportConfigurationBuilder transportBuilder = builder.transport();
        if (transport != null) {
            Channel channel;
            ChannelProvider.init(transportBuilder, transport.getChannel());
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                transportBuilder.distributedSyncTimeout(timeout.longValue());
            }
            if ((channel = transport.getChannel()).getAddress() instanceof TopologyUUID) {
                String machine;
                String rack;
                TopologyUUID topologyAddress = (TopologyUUID)channel.getAddress();
                String site = topologyAddress.getSiteId();
                if (site != null) {
                    transportBuilder.siteId(site);
                }
                if ((rack = topologyAddress.getRackId()) != null) {
                    transportBuilder.rackId(rack);
                }
                if ((machine = topologyAddress.getMachineId()) != null) {
                    transportBuilder.machineId(machine);
                }
            }
            transportBuilder.clusterName(this.name);
            Executor executor = transport.getExecutor();
            if (executor != null) {
                ExecutorProvider.initTransportExecutor(builder, executor);
            }
        }
        if ((listenerExecutor = this.dependencies.getListenerExecutor()) != null) {
            ExecutorProvider.initListenerExecutor(builder, listenerExecutor);
        }
        if ((evictionExecutor = this.dependencies.getEvictionExecutor()) != null) {
            ExecutorProvider.initEvictionExecutor(builder, evictionExecutor);
        }
        if ((replicationQueueExecutor = this.dependencies.getReplicationQueueExecutor()) != null) {
            ExecutorProvider.initReplicationQueueExecutor(builder, replicationQueueExecutor);
        }
        GlobalJmxStatisticsConfigurationBuilder jmxBuilder = builder.globalJmxStatistics().cacheManagerName(this.name);
        MBeanServer server = this.dependencies.getMBeanServer();
        if (server != null) {
            jmxBuilder.enable().mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).jmxDomain(EmbeddedCacheManagerService.getServiceName(null).getCanonicalName()).allowDuplicateDomains(Boolean.valueOf(true));
        } else {
            jmxBuilder.disable();
        }
        this.config = builder.build();
    }

    public void stop(StopContext context) {
    }

    static interface Dependencies {
        public ClassLoader getClassLoader();

        public TransportConfiguration getTransportConfiguration();

        public MBeanServer getMBeanServer();

        public Executor getListenerExecutor();

        public ScheduledExecutorService getEvictionExecutor();

        public ScheduledExecutorService getReplicationQueueExecutor();
    }

    static interface TransportConfiguration {
        public Long getLockTimeout();

        public Channel getChannel();

        public Executor getExecutor();
    }
}

