/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.HashMap;

public final class JDBCEntityCommandMetaData {
    private String commandName;
    private Class<?> commandClass;
    private final HashMap<String, String> attributes = new HashMap();

    public JDBCEntityCommandMetaData() {
    }

    public JDBCEntityCommandMetaData(JDBCEntityCommandMetaData entityCommand, JDBCEntityCommandMetaData defaultValues) {
        this.commandName = defaultValues.getCommandName();
        this.commandClass = entityCommand.getCommandClass() != null ? entityCommand.getCommandClass() : defaultValues.getCommandClass();
        this.attributes.putAll(defaultValues.attributes);
        this.attributes.putAll(entityCommand.attributes);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Class<?> getCommandClass() {
        return this.commandClass;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String toString() {
        return new StringBuffer("[commandName=").append(this.commandName).append(",commandClass=").append(this.commandClass).append(",attributes=").append(this.attributes.toString()).append("]").toString();
    }

    public void setName(String commandName) {
        this.commandName = commandName;
    }

    public void setClass(Class<?> commandClass) {
        this.commandClass = commandClass;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }
}

