/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.SharedWebMetaDataBuilder;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebServerService;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.EarContextRootProcessor;
import org.jboss.as.web.deployment.JBossWebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.ServletContainerInitializerDeploymentProcessor;
import org.jboss.as.web.deployment.TldParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WarAnnotationDeploymentProcessor;
import org.jboss.as.web.deployment.WarClassloadingDependencyProcessor;
import org.jboss.as.web.deployment.WarDeploymentInitializingProcessor;
import org.jboss.as.web.deployment.WarDeploymentProcessor;
import org.jboss.as.web.deployment.WarMetaDataProcessor;
import org.jboss.as.web.deployment.WarStructureDeploymentProcessor;
import org.jboss.as.web.deployment.WebFragmentParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WebInitializeInOrderProcessor;
import org.jboss.as.web.deployment.WebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.component.WebComponentProcessor;
import org.jboss.as.web.deployment.jsf.JsfAnnotationProcessor;
import org.jboss.as.web.deployment.jsf.JsfManagedBeanProcessor;
import org.jboss.as.web.deployment.jsf.JsfVersionProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class WebSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final WebSubsystemAdd INSTANCE = new WebSubsystemAdd();
    private static final String TEMP_DIR = "jboss.server.temp.dir";

    private WebSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        WebDefinition.DEFAULT_VIRTUAL_SERVER.validateAndSet(operation, model);
        WebDefinition.NATIVE.validateAndSet(operation, model);
        WebDefinition.INSTANCE_ID.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode baseOperation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        final ModelNode config = this.resolveConfiguration(context, fullModel.get("configuration"));
        final String defaultVirtualServer = WebDefinition.DEFAULT_VIRTUAL_SERVER.resolveModelAttribute(context, fullModel).asString();
        boolean useNative = WebDefinition.NATIVE.resolveModelAttribute(context, fullModel).asBoolean();
        String instanceId = WebDefinition.INSTANCE_ID.resolveModelAttribute(context, fullModel).asString();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                SharedWebMetaDataBuilder sharedWebBuilder = new SharedWebMetaDataBuilder(config.clone());
                SharedTldsMetaDataBuilder sharedTldsBuilder = new SharedTldsMetaDataBuilder(config.clone());
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 2048, (DeploymentUnitProcessor)new WarDeploymentInitializingProcessor());
                processorTarget.addDeploymentProcessor(Phase.STRUCTURE, 2304, (DeploymentUnitProcessor)new WarStructureDeploymentProcessor(sharedWebBuilder.create(), sharedTldsBuilder));
                processorTarget.addDeploymentProcessor(Phase.PARSE, 2816, (DeploymentUnitProcessor)new WebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3072, (DeploymentUnitProcessor)new WebFragmentParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3152, (DeploymentUnitProcessor)new JsfVersionProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3584, (DeploymentUnitProcessor)new JBossWebParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3840, (DeploymentUnitProcessor)new TldParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 3328, (DeploymentUnitProcessor)new WarAnnotationDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7936, (DeploymentUnitProcessor)new WebComponentProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4096, (DeploymentUnitProcessor)new EarContextRootProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 8192, (DeploymentUnitProcessor)new WarMetaDataProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 768, (DeploymentUnitProcessor)new JsfManagedBeanProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 15360, (DeploymentUnitProcessor)new WebInitializeInOrderProcessor(defaultVirtualServer));
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 1536, (DeploymentUnitProcessor)new WarClassloadingDependencyProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 768, (DeploymentUnitProcessor)new JsfManagedBeanProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4864, (DeploymentUnitProcessor)new ServletContainerInitializerDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 5632, (DeploymentUnitProcessor)new JsfAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 7424, (DeploymentUnitProcessor)new WarDeploymentProcessor(defaultVirtualServer));
            }
        }, OperationContext.Stage.RUNTIME);
        WebServerService service = new WebServerService(defaultVirtualServer, useNative, instanceId);
        newControllers.add(context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB, (Service)service).addDependency(AbstractPathService.pathNameOf((String)TEMP_DIR), String.class, service.getPathInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, service.getMbeanServer()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    private ModelNode resolveConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode res = new ModelNode();
        for (AttributeDefinition attributeDefinition : WebContainerDefinition.CONTAINER_ATTRIBUTES) {
            res.get("container").get(attributeDefinition.getName()).set(attributeDefinition.resolveModelAttribute(context, model));
        }
        for (AttributeDefinition attributeDefinition : WebStaticResources.STATIC_ATTRIBUTES) {
            res.get("static-resources").get(attributeDefinition.getName()).set(attributeDefinition.resolveModelAttribute(context, model));
        }
        for (AttributeDefinition attributeDefinition : WebJSPDefinition.JSP_ATTRIBUTES) {
            res.get("jsp-configuration").get(attributeDefinition.getName()).set(attributeDefinition.resolveModelAttribute(context, model));
        }
        return res;
    }
}

