/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.GlobalTransformerRegistry;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.dmr.ModelNode;

public class OperationTransformerRegistry {
    private final ResourceTransformerEntry resourceTransformer;
    private final OperationTransformerEntry defaultTransformer;
    private volatile Map<String, SubRegistry> subRegistries;
    private volatile Map<String, OperationTransformerEntry> transformerEntries;
    private static final AtomicMapFieldUpdater<OperationTransformerRegistry, String, SubRegistry> subRegistriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(OperationTransformerRegistry.class, Map.class, "subRegistries"));
    private static final AtomicMapFieldUpdater<OperationTransformerRegistry, String, OperationTransformerEntry> entriesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(OperationTransformerRegistry.class, Map.class, "transformerEntries"));
    static OperationTransformer FORWARD_TRANSFORMER = new OperationTransformer(){

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    };
    static OperationTransformer DISCARD_TRANSFORMER = new OperationTransformer(){

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) {
            return new OperationTransformer.TransformedOperation(null, new OperationResultTransformer(){

                @Override
                public ModelNode transformResult(ModelNode ignore) {
                    ModelNode result = new ModelNode();
                    result.get("outcome").set("success");
                    result.get("result");
                    return result;
                }
            });
        }
    };
    public static OperationTransformerEntry DISCARD = new OperationTransformerEntry(DISCARD_TRANSFORMER, TransformationPolicy.DISCARD);
    public static OperationTransformerEntry FORWARD = new OperationTransformerEntry(FORWARD_TRANSFORMER, TransformationPolicy.FORWARD);

    protected OperationTransformerRegistry(ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer) {
        entriesUpdater.clear(this);
        subRegistriesUpdater.clear(this);
        this.defaultTransformer = defaultTransformer;
        this.resourceTransformer = resourceTransformer;
    }

    public ResourceTransformerEntry resolveResourceTransformer(PathAddress address) {
        return this.resolveResourceTransformer(address.iterator(), null);
    }

    public OperationTransformerEntry resolveOperationTransformer(PathAddress address, String operationName) {
        Iterator iterator = address.iterator();
        OperationTransformerEntry entry = this.resolveTransformer(iterator, operationName);
        if (entry != null) {
            return entry;
        }
        return FORWARD;
    }

    public void mergeSubsystem(GlobalTransformerRegistry registry, String subsystemName, ModelVersion version) {
        PathElement element = PathElement.pathElement("subsystem", subsystemName);
        registry.mergeSubtree(this, PathAddress.EMPTY_ADDRESS.append(element), version);
    }

    public OperationTransformerRegistry getChild(PathAddress address) {
        Iterator iterator = address.iterator();
        return this.resolveChild(iterator);
    }

    protected OperationTransformerRegistry resolveChild(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        SubRegistry sub = subRegistriesUpdater.get(this, element.getKey());
        if (sub == null) {
            return null;
        }
        return sub.get(element.getValue());
    }

    protected void registerTransformer(PathAddress address, String operationName, OperationTransformer transformer) {
        this.registerTransformer(address.iterator(), operationName, new OperationTransformerEntry(transformer, TransformationPolicy.TRANSFORM));
    }

    public ResourceTransformerEntry getResourceTransformer() {
        return this.resourceTransformer;
    }

    public OperationTransformerEntry getDefaultTransformer() {
        return this.defaultTransformer;
    }

    protected Map<String, OperationTransformerEntry> getTransformers() {
        return entriesUpdater.get(this);
    }

    protected OperationTransformerRegistry createChildRegistry(Iterator<PathElement> iterator, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement element = iterator.next();
        return this.getOrCreate(element.getKey()).createChild(iterator, element.getValue(), resourceTransformer, defaultTransformer);
    }

    protected void registerTransformer(Iterator<PathElement> iterator, String operationName, OperationTransformerEntry entry) {
        if (!iterator.hasNext()) {
            OperationTransformerEntry existing = entriesUpdater.putIfAbsent(this, operationName, entry);
            if (existing != null) {
                throw new IllegalStateException("duplicate transformer " + operationName);
            }
        } else {
            PathElement element = iterator.next();
            this.getOrCreate(element.getKey()).registerTransformer(iterator, element.getValue(), operationName, entry);
        }
    }

    protected ResourceTransformerEntry resolveResourceTransformer(Iterator<PathElement> iterator, ResourceTransformerEntry inherited) {
        if (!iterator.hasNext()) {
            if (this.resourceTransformer == null) {
                return inherited;
            }
            return this.resourceTransformer;
        }
        ResourceTransformerEntry inheritedEntry = this.resourceTransformer.inherited ? this.resourceTransformer : inherited;
        PathElement element = iterator.next();
        String key = element.getKey();
        SubRegistry registry = subRegistriesUpdater.get(this, key);
        if (registry == null) {
            return inherited;
        }
        return registry.resolveResourceTransformer(iterator, element.getValue(), inheritedEntry);
    }

    protected OperationTransformerEntry resolveTransformer(Iterator<PathElement> iterator, String operationName) {
        if (!iterator.hasNext()) {
            OperationTransformerEntry entry = entriesUpdater.get(this, operationName);
            if (entry == null) {
                return this.defaultTransformer;
            }
            return entry;
        }
        PathElement element = iterator.next();
        String key = element.getKey();
        SubRegistry registry = subRegistriesUpdater.get(this, key);
        if (registry == null) {
            return null;
        }
        return registry.resolveTransformer(iterator, element.getValue(), operationName);
    }

    SubRegistry getOrCreate(String key) {
        Map<String, SubRegistry> subRegistries = subRegistriesUpdater.get(this);
        SubRegistry registry = subRegistries.get(key);
        if (registry == null) {
            registry = new SubRegistry();
            SubRegistry existing = subRegistriesUpdater.putAtomic(this, key, registry, subRegistries);
            if (existing == null) {
                return registry;
            }
            if (existing != registry) {
                return existing;
            }
        }
        return registry;
    }

    public static class OperationTransformerEntry {
        final OperationTransformer transformer;
        final TransformationPolicy policy;

        public OperationTransformerEntry(OperationTransformer transformer, TransformationPolicy policy) {
            this.transformer = transformer;
            this.policy = policy;
        }

        public OperationTransformer getTransformer() {
            return this.transformer;
        }

        public TransformationPolicy getPolicy() {
            return this.policy;
        }
    }

    public static class ResourceTransformerEntry {
        private final ResourceTransformer transformer;
        private final boolean inherited;

        public ResourceTransformerEntry(ResourceTransformer transformer, boolean inherited) {
            this.transformer = transformer;
            this.inherited = inherited;
        }

        public ResourceTransformer getTransformer() {
            return this.transformer;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }

    public static enum TransformationPolicy {
        TRANSFORM,
        FORWARD,
        DISCARD;

    }

    static class SubRegistry {
        private static final AtomicMapFieldUpdater<SubRegistry, String, OperationTransformerRegistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(SubRegistry.class, Map.class, "entries"));
        private volatile Map<String, OperationTransformerRegistry> entries;

        SubRegistry() {
            childrenUpdater.clear(this);
        }

        public OperationTransformerEntry resolveTransformer(Iterator<PathElement> iterator, String value, String operationName) {
            OperationTransformerRegistry reg = this.get(value);
            if (reg == null) {
                return null;
            }
            return reg.resolveTransformer(iterator, operationName);
        }

        public OperationTransformerRegistry createChild(Iterator<PathElement> iterator, String value, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer) {
            if (!iterator.hasNext()) {
                return this.create(value, resourceTransformer, defaultTransformer);
            }
            OperationTransformerRegistry entry = this.get(value);
            if (entry == null) {
                entry = this.create(value, GlobalTransformerRegistry.RESOURCE_TRANSFORMER, FORWARD);
            }
            return entry.createChildRegistry(iterator, resourceTransformer, defaultTransformer);
        }

        public void registerTransformer(Iterator<PathElement> iterator, String value, String operationName, OperationTransformerEntry entry) {
            this.get(value).registerTransformer(iterator, operationName, entry);
        }

        OperationTransformerRegistry get(String value) {
            OperationTransformerRegistry entry = childrenUpdater.get(this, value);
            if (entry == null && (entry = childrenUpdater.get(this, "*")) == null) {
                return null;
            }
            return entry;
        }

        OperationTransformerRegistry create(String value, ResourceTransformerEntry resourceTransformer, OperationTransformerEntry defaultTransformer) {
            OperationTransformerRegistry entry;
            OperationTransformerRegistry existing;
            do {
                Map<String, OperationTransformerRegistry> entries;
                if ((entry = (entries = childrenUpdater.get(this)).get(value)) != null) {
                    return entry;
                }
                entry = new OperationTransformerRegistry(resourceTransformer, defaultTransformer);
                existing = childrenUpdater.putAtomic(this, value, entry, entries);
                if (existing != null) continue;
                return entry;
            } while (existing == entry);
            return existing;
        }

        public ResourceTransformerEntry resolveResourceTransformer(Iterator<PathElement> iterator, String value, ResourceTransformerEntry inheritedEntry) {
            OperationTransformerRegistry registry = this.get(value);
            if (registry == null) {
                return inheritedEntry;
            }
            return registry.resolveResourceTransformer(iterator, inheritedEntry);
        }
    }
}

