/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.interfaces.AnyInterfaceCriteria;
import org.jboss.as.controller.interfaces.CriteriaValidator;
import org.jboss.as.controller.interfaces.InetAddressMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.interfaces.LinkLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.LoopbackInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicInterfaceCriteria;
import org.jboss.as.controller.interfaces.NicMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.NotInterfaceCriteria;
import org.jboss.as.controller.interfaces.PointToPointInterfaceCriteria;
import org.jboss.as.controller.interfaces.PublicAddressInterfaceCriteria;
import org.jboss.as.controller.interfaces.SiteLocalInterfaceCriteria;
import org.jboss.as.controller.interfaces.SubnetMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.SupportsMulticastInterfaceCriteria;
import org.jboss.as.controller.interfaces.UpInterfaceCriteria;
import org.jboss.as.controller.interfaces.VirtualInterfaceCriteria;
import org.jboss.as.controller.interfaces.WildcardInetAddressInterfaceCriteria;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class ParsedInterfaceCriteria {
    private static final ParsedInterfaceCriteria ANY = new ParsedInterfaceCriteria(false, false, true);
    private static final ParsedInterfaceCriteria V4 = new ParsedInterfaceCriteria(true, false, false);
    private static final ParsedInterfaceCriteria V6 = new ParsedInterfaceCriteria(false, true, false);
    private final String failureMessage;
    private final boolean anyLocalV4;
    private final boolean anyLocalV6;
    private final boolean anyLocal;
    private final Set<InterfaceCriteria> criteria = new HashSet<InterfaceCriteria>();

    private ParsedInterfaceCriteria(String failureMessage) {
        this.failureMessage = failureMessage;
        this.anyLocalV6 = false;
        this.anyLocalV4 = false;
        this.anyLocal = false;
    }

    private ParsedInterfaceCriteria(boolean anyLocalV4, boolean anyLocalV6, boolean anyLocal) {
        this.failureMessage = null;
        this.anyLocal = anyLocal;
        this.anyLocalV4 = anyLocalV4;
        this.anyLocalV6 = anyLocalV6;
    }

    private ParsedInterfaceCriteria(Set<InterfaceCriteria> criteria) {
        this.failureMessage = null;
        this.anyLocalV6 = false;
        this.anyLocalV4 = false;
        this.anyLocal = false;
        this.criteria.addAll(criteria);
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isAnyLocalV4() {
        return this.anyLocalV4;
    }

    public boolean isAnyLocalV6() {
        return this.anyLocalV6;
    }

    public boolean isAnyLocal() {
        return this.anyLocal;
    }

    public Set<InterfaceCriteria> getCriteria() {
        return this.criteria;
    }

    public static ParsedInterfaceCriteria parse(ModelNode criteria) {
        return ParsedInterfaceCriteria.parse(criteria, true, null);
    }

    public static ParsedInterfaceCriteria parse(ModelNode criteria, boolean specified) {
        return ParsedInterfaceCriteria.parse(criteria, specified, null);
    }

    public static ParsedInterfaceCriteria parse(ModelNode model, boolean specified, OperationContext context) {
        ParsedInterfaceCriteria parsed;
        if (model.getType() != ModelType.OBJECT) {
            return new ParsedInterfaceCriteria(ControllerMessages.MESSAGES.illegalInterfaceCriteria(model.getType(), ModelType.OBJECT));
        }
        ModelNode subModel = model.clone();
        subModel.remove("operation");
        subModel.remove("address");
        subModel.remove("operation-headers");
        if (subModel.hasDefined("any-address") && subModel.get("any-address").asBoolean(false)) {
            parsed = ANY;
        } else if (subModel.hasDefined("any-ipv4-address") && subModel.get("any-ipv4-address").asBoolean(false)) {
            parsed = V4;
        } else if (subModel.hasDefined("any-ipv6-address") && subModel.get("any-ipv6-address").asBoolean(false)) {
            parsed = V6;
        } else {
            try {
                List nodes = subModel.asPropertyList();
                HashSet<InterfaceCriteria> criteriaSet = new HashSet<InterfaceCriteria>();
                for (Property property : nodes) {
                    InterfaceCriteria criterion = ParsedInterfaceCriteria.parseCriteria(property, false, context);
                    if (criterion instanceof WildcardInetAddressInterfaceCriteria) {
                        if (nodes.size() > 1) {
                            ControllerLogger.SERVER_LOGGER.wildcardAddressDetected();
                        }
                        WildcardInetAddressInterfaceCriteria wc = (WildcardInetAddressInterfaceCriteria)criterion;
                        switch (wc.getVersion()) {
                            case V4: {
                                return V4;
                            }
                            case V6: {
                                return V6;
                            }
                        }
                        return ANY;
                    }
                    if (criterion == null) continue;
                    criteriaSet.add(criterion);
                }
                String validation = new CriteriaValidator(criteriaSet).validate();
                parsed = validation == null ? new ParsedInterfaceCriteria(criteriaSet) : new ParsedInterfaceCriteria(validation);
            }
            catch (ParsingException p) {
                return new ParsedInterfaceCriteria(p.msg);
            }
            catch (OperationFailedException e) {
                return new ParsedInterfaceCriteria(e.getMessage());
            }
        }
        if (specified && parsed.getFailureMessage() == null && !parsed.isAnyLocal() && !parsed.isAnyLocalV4() && !parsed.isAnyLocalV6() && parsed.getCriteria().size() == 0) {
            return new ParsedInterfaceCriteria(ControllerMessages.MESSAGES.noInterfaceCriteria());
        }
        return parsed;
    }

    private static InterfaceCriteria parseCriteria(Property property, boolean nested, OperationContext context) throws OperationFailedException {
        Element element = Element.forName(property.getName());
        switch (element) {
            case LINK_LOCAL_ADDRESS: {
                return LinkLocalInterfaceCriteria.INSTANCE;
            }
            case LOOPBACK: {
                return LoopbackInterfaceCriteria.INSTANCE;
            }
            case MULTICAST: {
                return SupportsMulticastInterfaceCriteria.INSTANCE;
            }
            case POINT_TO_POINT: {
                return PointToPointInterfaceCriteria.INSTANCE;
            }
            case PUBLIC_ADDRESS: {
                return PublicAddressInterfaceCriteria.INSTANCE;
            }
            case SITE_LOCAL_ADDRESS: {
                return SiteLocalInterfaceCriteria.INSTANCE;
            }
            case UP: {
                return UpInterfaceCriteria.INSTANCE;
            }
            case VIRTUAL: {
                return VirtualInterfaceCriteria.INSTANCE;
            }
            case INET_ADDRESS: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(value, element.getLocalName(), true);
                return ParsedInterfaceCriteria.createInetAddressCriteria(value, context);
            }
            case LOOPBACK_ADDRESS: {
                ModelNode value = ParsedInterfaceCriteria.parsePossibleExpression(property.getValue());
                ParsedInterfaceCriteria.checkStringType(value, element.getLocalName(), true);
                return new LoopbackAddressInterfaceCriteria(ParsedInterfaceCriteria.parseInetAddress(value, context));
            }
            case NIC: {
                ParsedInterfaceCriteria.checkStringType(property.getValue(), element.getLocalName());
                return new NicInterfaceCriteria(property.getValue().asString());
            }
            case NIC_MATCH: {
                ParsedInterfaceCriteria.checkStringType(property.getValue(), element.getLocalName());
                return ParsedInterfaceCriteria.createNicMatchCriteria(property.getValue());
            }
            case SUBNET_MATCH: {
                return ParsedInterfaceCriteria.createSubnetMatchCriteria(property.getValue());
            }
            case ANY: 
            case NOT: {
                if (nested) {
                    throw new ParsingException(ControllerMessages.MESSAGES.nestedElementNotAllowed(element));
                }
                return ParsedInterfaceCriteria.parseNested(property.getValue(), element == Element.ANY, context);
            }
        }
        throw new ParsingException(ControllerMessages.MESSAGES.unknownCriteriaInterfaceType(property.getName()));
    }

    private static InterfaceCriteria parseNested(ModelNode subModel, boolean any, OperationContext context) throws OperationFailedException {
        if (!subModel.isDefined() || subModel.asInt() == 0) {
            return null;
        }
        HashSet<InterfaceCriteria> criteriaSet = new HashSet<InterfaceCriteria>();
        block3: for (Property nestedProperty : subModel.asPropertyList()) {
            Element element = Element.forName(nestedProperty.getName());
            switch (element) {
                case INET_ADDRESS: 
                case NIC: 
                case NIC_MATCH: 
                case SUBNET_MATCH: {
                    if (nestedProperty.getValue().getType() == ModelType.LIST) {
                        for (ModelNode item : nestedProperty.getValue().asList()) {
                            Property prop = new Property(nestedProperty.getName(), item);
                            InterfaceCriteria itemCriteria = ParsedInterfaceCriteria.parseCriteria(prop, true, context);
                            if (itemCriteria == null) continue;
                            criteriaSet.add(itemCriteria);
                        }
                        continue block3;
                    }
                }
                default: {
                    InterfaceCriteria criteria = ParsedInterfaceCriteria.parseCriteria(nestedProperty, true, context);
                    if (criteria == null) continue block3;
                    criteriaSet.add(criteria);
                }
            }
        }
        if (criteriaSet.isEmpty()) {
            return null;
        }
        return any ? new AnyInterfaceCriteria(criteriaSet) : new NotInterfaceCriteria(criteriaSet);
    }

    private static InterfaceCriteria createInetAddressCriteria(ModelNode model, OperationContext context) throws ParsingException, OperationFailedException {
        InetAddress address = ParsedInterfaceCriteria.parseInetAddress(model, context);
        if (address.isAnyLocalAddress()) {
            return new WildcardInetAddressInterfaceCriteria(address);
        }
        return new InetAddressMatchInterfaceCriteria(address);
    }

    private static InterfaceCriteria createNicMatchCriteria(ModelNode model) throws ParsingException {
        try {
            Pattern pattern = Pattern.compile(model.asString());
            return new NicMatchInterfaceCriteria(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ParsingException(ControllerMessages.MESSAGES.invalidInterfaceCriteriaPattern(model.asString(), Element.NIC_MATCH.getLocalName()));
        }
    }

    private static InterfaceCriteria createSubnetMatchCriteria(ModelNode model) throws ParsingException {
        String[] split = null;
        try {
            String value = model.asString();
            split = value.split("/");
            if (split.length != 2) {
                throw new ParsingException(ControllerMessages.MESSAGES.invalidAddressMaskValue(value));
            }
            InetAddress addr = InetAddress.getByName(split[0]);
            byte[] net = addr.getAddress();
            int mask = Integer.parseInt(split[1]);
            return new SubnetMatchInterfaceCriteria(net, mask);
        }
        catch (NumberFormatException e) {
            throw new ParsingException(ControllerMessages.MESSAGES.invalidAddressMask(split[1], e.getLocalizedMessage()));
        }
        catch (UnknownHostException e) {
            throw new ParsingException(ControllerMessages.MESSAGES.invalidAddressValue(split[0], e.getLocalizedMessage()));
        }
    }

    private static InetAddress parseInetAddress(ModelNode model, OperationContext context) throws OperationFailedException {
        String rawAddress = context == null ? model.resolve().asString() : context.resolveExpressions(model).asString();
        try {
            return InetAddress.getByName(rawAddress);
        }
        catch (UnknownHostException e) {
            throw new ParsingException(ControllerMessages.MESSAGES.invalidAddress(model.asString(), e.getLocalizedMessage()));
        }
    }

    private static void checkStringType(ModelNode node, String id) {
        ParsedInterfaceCriteria.checkStringType(node, id, false);
    }

    private static void checkStringType(ModelNode node, String id, boolean allowExpressions) {
        if (!(node.getType() == ModelType.STRING || allowExpressions && node.getType() == ModelType.EXPRESSION)) {
            throw new ParsingException(ControllerMessages.MESSAGES.illegalValueForInterfaceCriteria(node.getType(), id, ModelType.STRING));
        }
    }

    private static ModelNode parsePossibleExpression(ModelNode node) {
        return node.getType() == ModelType.STRING ? ParseUtils.parsePossibleExpression(node.asString()) : node;
    }

    private static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = -5627251228393035383L;
        private final String msg;

        private ParsingException(String msg) {
            this.msg = msg;
        }
    }
}

