/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXContext {
    private String host;
    private int port;
    private MBeanServerConnection connection;

    public JMXContext(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public JMXContext(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public MBeanServerConnection getConnection() {
        if (this.connection == null) {
            try {
                this.connection = JMXConnectorFactory.connect(this.getRemoteJMXURL(), null).getMBeanServerConnection();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create remote JMX connection: " + this, e);
            }
        }
        return this.connection;
    }

    private JMXServiceURL getRemoteJMXURL() {
        try {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/jmxrmi");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    public String toString() {
        return "JMXContext [host=" + this.host + ", port=" + this.port + ", connection=" + this.connection + "]";
    }
}

