/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jasig.maven.notice.LicenseLookupHelper;
import org.jasig.maven.notice.ResolvedLicense;
import org.jasig.maven.notice.lookup.ArtifactLicense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LicenseResolvingNodeVisitor
implements DependencyNodeVisitor {
    private final Map<String, String> resolvedLicenses = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Set<Artifact> unresolvedArtifacts = new TreeSet<Artifact>();
    private final Set<Artifact> visitedArtifacts = new HashSet<Artifact>();
    private final Log logger;
    private final LicenseLookupHelper licenseLookupHelper;
    private final List<?> remoteArtifactRepositories;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final ArtifactRepository localRepository;

    LicenseResolvingNodeVisitor(Log logger, LicenseLookupHelper licenseLookupHelper, List<?> remoteArtifactRepositories, MavenProjectBuilder mavenProjectBuilder, ArtifactRepository localRepository) {
        this.logger = logger;
        this.licenseLookupHelper = licenseLookupHelper;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.localRepository = localRepository;
    }

    public Map<String, String> getResolvedLicenses() {
        return this.resolvedLicenses;
    }

    public Set<Artifact> getUnresolvedArtifacts() {
        return this.unresolvedArtifacts;
    }

    public boolean visit(DependencyNode node) {
        if (0 == node.getState()) {
            MavenProject artifactProject;
            ArtifactLicense artifactLicense;
            Artifact artifact = node.getArtifact();
            if (!this.visitedArtifacts.add(artifact)) {
                return true;
            }
            String name = null;
            String licenseName = null;
            ResolvedLicense resolvedLicense = this.loadLicenseMapping(artifact);
            if (resolvedLicense != null && resolvedLicense.getVersionType() != null) {
                artifactLicense = resolvedLicense.getArtifactLicense();
                name = StringUtils.trimToNull((String)artifactLicense.getName());
                licenseName = StringUtils.trimToNull((String)artifactLicense.getLicense());
            }
            if ((name == null || licenseName == null) && (artifactProject = this.loadProject(artifact)) != null) {
                if (name == null) {
                    name = artifactProject.getName();
                }
                if (licenseName == null) {
                    Model model = artifactProject.getModel();
                    List licenses = model.getLicenses();
                    if (licenses.size() == 1) {
                        licenseName = ((License)licenses.get(0)).getName();
                    } else if (licenses.size() > 1) {
                        StringBuilder licenseNameBuilder = new StringBuilder();
                        Iterator licenseItr = licenses.iterator();
                        while (licenseItr.hasNext()) {
                            License license = (License)licenseItr.next();
                            licenseNameBuilder.append(license.getName());
                            if (!licenseItr.hasNext()) continue;
                            licenseNameBuilder.append(" or ");
                        }
                        licenseName = licenseNameBuilder.toString();
                    }
                }
            }
            if (resolvedLicense != null && (licenseName == null || name == null)) {
                artifactLicense = resolvedLicense.getArtifactLicense();
                if (name == null) {
                    name = StringUtils.trimToNull((String)artifactLicense.getName());
                }
                if (licenseName == null) {
                    licenseName = StringUtils.trimToNull((String)artifactLicense.getLicense());
                }
            }
            if (name == null) {
                name = artifact.getGroupId() + ":" + artifact.getArtifactId();
            }
            if (licenseName == null) {
                this.unresolvedArtifacts.add(artifact);
            } else {
                this.resolvedLicenses.put(name, licenseName);
            }
        }
        return true;
    }

    protected ResolvedLicense loadLicenseMapping(Artifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        DefaultArtifactVersion version = new DefaultArtifactVersion(artifact.getVersion());
        ResolvedLicense resolvedLicense = this.licenseLookupHelper.lookupLicenseMapping(groupId, artifactId, (ArtifactVersion)version);
        return resolvedLicense;
    }

    protected MavenProject loadProject(Artifact artifact) {
        try {
            return this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteArtifactRepositories, this.localRepository, false);
        }
        catch (ProjectBuildingException e) {
            this.logger.warn((CharSequence)("Failed to find license info for: " + artifact));
            return null;
        }
    }

    public boolean endVisit(DependencyNode node) {
        return true;
    }
}

