/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.jasig.cas.web.flow.CasFlowExecutionKey;
import org.springframework.util.StringUtils;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;

public final class CasFlowExecutionKeyFactory
extends DefaultFlowExecutionRepository {
    private static final String UUID_KEY = "CAS_UUID";
    private final SecureRandom secureRandom = new SecureRandom();
    private boolean defaultBehavior = false;
    @NotNull
    private final ConversationManager conversationManager;

    public CasFlowExecutionKeyFactory(ConversationManager conversationManager, FlowExecutionSnapshotFactory snapshotFactory) {
        super(conversationManager, snapshotFactory);
        this.conversationManager = conversationManager;
    }

    public void setDefaultBehavior(boolean defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    public FlowExecutionKey getKey(FlowExecution execution) {
        if (this.defaultBehavior) {
            return super.getKey(execution);
        }
        CasFlowExecutionKey key = (CasFlowExecutionKey)execution.getKey();
        if (key == null) {
            Conversation conversation = this.conversationManager.beginConversation(this.createConversationParameters(execution));
            ConversationId executionId = conversation.getId();
            key = this.newKey(conversation, (Serializable)executionId);
        } else if (this.getAlwaysGenerateNewNextKey()) {
            Serializable executionId = key.getExecutionId();
            key = this.newKey(this.getConversation(executionId), executionId);
        }
        return key;
    }

    public FlowExecutionKey parseFlowExecutionKey(String encodedKey) throws FlowExecutionRepositoryException {
        UUID uuid;
        if (this.defaultBehavior) {
            return super.parseFlowExecutionKey(encodedKey);
        }
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new IllegalStateException("The string-encoded flow execution key is required");
        }
        String[] keyParts = CasFlowExecutionKey.keyParts((String)encodedKey);
        try {
            uuid = UUID.fromString(keyParts[0]);
        }
        catch (Exception exception) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, "LT-{UUID}Ze{executionId}s{snapshotId}");
        }
        ConversationId executionId = this.parseExecutionId(keyParts[1], encodedKey);
        Serializable snapshotId = this.parseSnapshotId(keyParts[2], encodedKey);
        this.validateUUID(uuid, (Serializable)executionId);
        return new CasFlowExecutionKey((Serializable)executionId, snapshotId, uuid);
    }

    private ConversationId parseExecutionId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return this.conversationManager.parseConversationId(encodedId);
        }
        catch (ConversationException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)e);
        }
    }

    private Serializable parseSnapshotId(String encodedId, String encodedKey) throws BadlyFormattedFlowExecutionKeyException {
        try {
            return Integer.valueOf(encodedId);
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedFlowExecutionKeyException(encodedKey, CompositeFlowExecutionKey.getFormat(), (Throwable)e);
        }
    }

    private CasFlowExecutionKey newKey(Conversation conversation, Serializable executionId) {
        long hi_word = (long)this.secureRandom.nextInt() << 32;
        long lo_word = System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL;
        UUID uuid = new UUID(hi_word | lo_word, this.secureRandom.nextLong());
        conversation.lock();
        try {
            conversation.putAttribute((Object)UUID_KEY, (Object)uuid);
        }
        finally {
            conversation.unlock();
        }
        return new CasFlowExecutionKey(executionId, this.nextSnapshotId(executionId), uuid);
    }

    private void validateUUID(UUID givenUUID, Serializable executionId) {
        Conversation conversation = this.getConversation(executionId);
        conversation.lock();
        try {
            UUID savedUUID = (UUID)conversation.getAttribute((Object)UUID_KEY);
            if (!givenUUID.equals(savedUUID)) {
                throw new IllegalStateException("UUID component of flow execution key not recognized.");
            }
        }
        finally {
            conversation.unlock();
        }
    }
}

