/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.io.Serializable;
import java.util.UUID;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;

public final class CasFlowExecutionKey
extends CompositeFlowExecutionKey {
    public static final String FORMAT = "LT-{UUID}Ze{executionId}s{snapshotId}";
    public static final String KEY_PREFIX = "LT-";
    public static final String KEY_SEPARATOR = "Z";
    private static final long serialVersionUID = -1535846700101524714L;
    private final UUID uuid;

    public CasFlowExecutionKey(Serializable executionId, Serializable snapshotId, UUID uuid) {
        super(executionId, snapshotId);
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(KEY_PREFIX);
        sb.append(this.uuid);
        sb.append(KEY_SEPARATOR);
        sb.append(super.toString());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        return result;
    }

    public static String[] keyParts(String encodedKey) {
        String[] keyParts = new String[3];
        int keySeparatorIndex = encodedKey.indexOf(KEY_SEPARATOR);
        keyParts[0] = encodedKey.substring(KEY_PREFIX.length(), keySeparatorIndex);
        String originalKey = encodedKey.substring(keySeparatorIndex + 1);
        String[] originalKeys = CompositeFlowExecutionKey.keyParts((String)originalKey);
        keyParts[1] = originalKeys[0];
        keyParts[2] = originalKeys[1];
        return keyParts;
    }
}

