/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.collect.Ordering;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.immutables.value.processor.meta.ValueMirrors;

public enum Visibility {
    PRIVATE,
    PACKAGE,
    PUBLIC;


    public boolean isPublic() {
        return this == PUBLIC;
    }

    public boolean isPrivate() {
        return this == PRIVATE;
    }

    public Visibility forImplementation(ValueMirrors.Style.ImplementationVisibility visibility) {
        switch (visibility) {
            case PACKAGE: {
                return PACKAGE;
            }
            case PRIVATE: {
                return PRIVATE;
            }
            case PUBLIC: {
                return PUBLIC;
            }
        }
        return this;
    }

    public Visibility forBuilder(ValueMirrors.Style.BuilderVisibility visibility) {
        switch (visibility) {
            case PACKAGE: {
                return PACKAGE;
            }
            case PUBLIC: {
                return PUBLIC;
            }
        }
        return this.max(PACKAGE);
    }

    public Visibility max(Visibility visibility) {
        return (Visibility)((Object)Ordering.natural().max((Object)this, (Object)visibility));
    }

    public Visibility min(Visibility visibility) {
        return (Visibility)((Object)Ordering.natural().min((Object)this, (Object)visibility));
    }

    public static Visibility of(Element element) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        return PACKAGE;
    }

    public boolean isMoreRestrictiveThan(Visibility visibility) {
        return this.compareTo(visibility) < 0;
    }
}

