/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.encode.EncElementMirror;
import org.immutables.value.processor.encode.Mirrors;

public class EncMetadataMirror
implements Mirrors.EncMetadata {
    public static final String QUALIFIED_NAME = "org.immutables.encode.EncodingMetadata";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.encode.Mirrors.EncMetadata";
    private final AnnotationMirror annotationMirror;
    private final String name;
    private final String[] imports;
    private final String[] typeParams;
    private final AnnotationMirror[] elements;
    private final EncElementMirror[] elementsMirror;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "EncodingMetadata";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<EncMetadataMirror> find(Element element) {
        return EncMetadataMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<EncMetadataMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new EncMetadataMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<EncMetadataMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new EncMetadataMirror(annotationMirror));
        }
        return builder.build();
    }

    public static EncMetadataMirror from(TypeElement element) {
        return new EncMetadataMirror(element);
    }

    public static Optional<EncMetadataMirror> from(AnnotationMirror mirror) {
        return EncMetadataMirror.find(Collections.singleton(mirror));
    }

    private EncMetadataMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        String name = null;
        String[] imports = null;
        String[] typeParams = null;
        AnnotationMirror[] elements = null;
        EncElementMirror[] elementsMirror = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @EncodingMetadata");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("imports".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @EncodingMetadata");
                }
                ImportsExtractor importsExtractor$ = new ImportsExtractor();
                annotationValue$.accept(importsExtractor$, null);
                imports = importsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @EncodingMetadata");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if (!"elements".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @EncodingMetadata");
            }
            ElementsExtractor elementsExtractor$ = new ElementsExtractor();
            annotationValue$.accept(elementsExtractor$, null);
            elements = elementsExtractor$.get();
            elementsMirror = elementsExtractor$.mirror();
        }
        this.name = (String)Preconditions.checkNotNull(name, (Object)"default attribute 'name'");
        this.imports = (String[])Preconditions.checkNotNull(imports, (Object)"default attribute 'imports'");
        this.typeParams = (String[])Preconditions.checkNotNull(typeParams, (Object)"default attribute 'typeParams'");
        this.elements = (AnnotationMirror[])Preconditions.checkNotNull(elements, (Object)"default attribute 'elements'");
        this.elementsMirror = (EncElementMirror[])Preconditions.checkNotNull(elementsMirror, (Object)"default attribute 'elements'");
    }

    private EncMetadataMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String name = null;
        String[] imports = null;
        String[] typeParams = null;
        AnnotationMirror[] elements = null;
        EncElementMirror[] elementsMirror = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'name' attribute of @EncodingMetadata");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("imports".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'imports' attribute of @EncodingMetadata");
                }
                ImportsExtractor importsExtractor$ = new ImportsExtractor();
                annotationValue$.accept(importsExtractor$, null);
                imports = importsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeParams' attribute of @EncodingMetadata");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if (!"elements".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'elements' attribute of @EncodingMetadata");
            }
            ElementsExtractor elementsExtractor$ = new ElementsExtractor();
            annotationValue$.accept(elementsExtractor$, null);
            elements = elementsExtractor$.get();
            elementsMirror = elementsExtractor$.mirror();
        }
        this.name = (String)Preconditions.checkNotNull(name, (Object)"value for 'name'");
        this.imports = (String[])Preconditions.checkNotNull(imports, (Object)"value for 'imports'");
        this.typeParams = (String[])Preconditions.checkNotNull(typeParams, (Object)"value for 'typeParams'");
        this.elements = (AnnotationMirror[])Preconditions.checkNotNull(elements, (Object)"value for 'elements'");
        this.elementsMirror = (EncElementMirror[])Preconditions.checkNotNull(elementsMirror, (Object)"value for 'elements'");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String[] imports() {
        return (String[])this.imports.clone();
    }

    @Override
    public String[] typeParams() {
        return (String[])this.typeParams.clone();
    }

    public AnnotationMirror[] elementsMirror() {
        return (AnnotationMirror[])this.elements.clone();
    }

    public EncElementMirror[] elements() {
        return this.elementsMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Mirrors.EncMetadata.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "name".hashCode() ^ this.name.hashCode();
        h += 127 * "imports".hashCode() ^ Arrays.hashCode(this.imports);
        h += 127 * "typeParams".hashCode() ^ Arrays.hashCode(this.typeParams);
        return h += 127 * "elements".hashCode() ^ Arrays.hashCode(this.elements);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof EncMetadataMirror) {
            EncMetadataMirror otherMirror = (EncMetadataMirror)other;
            return this.name.equals(otherMirror.name) && Arrays.equals(this.imports, otherMirror.imports) && Arrays.equals(this.typeParams, otherMirror.typeParams) && Arrays.equals(this.elements, otherMirror.elements);
        }
        return false;
    }

    @Override
    public String toString() {
        return "EncMetadataMirror:" + this.annotationMirror;
    }

    private static class NameExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NameExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'name' in @org.immutables.encode.EncodingMetadata");
        }
    }

    private static class ImportsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private ImportsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'imports' in @org.immutables.encode.EncodingMetadata");
        }
    }

    private static class TypeParamsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TypeParamsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeParams' in @org.immutables.encode.EncodingMetadata");
        }
    }

    private static class ElementsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        AnnotationMirror[] values;
        int position;

        private ElementsExtractor() {
        }

        @Override
        public Void visitAnnotation(AnnotationMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new AnnotationMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        AnnotationMirror[] get() {
            return this.values;
        }

        public EncElementMirror[] mirror() {
            EncElementMirror[] mirrors = new EncElementMirror[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                mirrors[i] = (EncElementMirror)EncElementMirror.from(this.values[i]).get();
            }
            return mirrors;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'elements' in @org.immutables.encode.EncodingMetadata");
        }
    }
}

