/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneId;
import org.hibernate.search.engine.cfg.spi.ValidateUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultZoneIdValueBridge
implements ValueBridge<ZoneId, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toIndexedValue(ZoneId value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.getId();
    }

    @Override
    public ZoneId fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : ZoneId.of(value);
    }

    @Override
    public String parse(String value) {
        ValidateUtils.validateZoneId((String)value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }
}

