/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5Group
extends Group {
    public static final long serialVersionUID = 240L;
    protected List attributeList;
    private int nAttributes = -1;

    public H5Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    public H5Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray);
        this.nMembersInFile = -1;
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                this.oid = new long[1];
                this.oid[0] = 0L;
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        int n;
        if (this.nAttributes < 0 && (n = this.open()) > 0) {
            try {
                this.nAttributes = H5.H5Aget_num_attrs(n);
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            this.close(n);
        }
        return this.nAttributes > 0;
    }

    @Override
    public int getNumberOfMembersInFile() {
        int n;
        if (this.nMembersInFile < 0 && (n = this.open()) > 0) {
            try {
                long[] lArray = new long[]{0L};
                H5.H5Gget_num_objs(n, lArray);
                this.nMembersInFile = (int)lArray[0];
            }
            catch (Exception exception) {
                this.nMembersInFile = 0;
            }
            this.close(n);
        }
        return this.nMembersInFile;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDF5Exception {
        if (this.attributeList == null) {
            int n = this.open();
            try {
                this.attributeList = H5File.getAttribute(n);
            }
            finally {
                this.close(n);
            }
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        } else {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = this.isRoot() ? H5.H5Gopen(this.getFID(), "/") : H5.H5Gopen(this.getFID(), this.getPath() + this.getName());
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Gclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    public static H5Group create(String string, Group group) throws Exception {
        int n;
        H5Group h5Group = null;
        String string2 = null;
        if (string == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        if (group == null) {
            group = (Group)h5File.get("/");
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
        }
        string2 = string3 + string;
        n = H5.H5Gcreate(h5File.open(), string2, -1);
        try {
            H5.H5Gclose(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = H5.H5Rcreate(h5File.open(), string2, HDF5Constants.H5R_OBJECT, -1);
        long l = HDFNativeData.byteToLong(byArray, 0);
        long[] lArray = new long[]{l};
        h5Group = new H5Group(h5File, string, string3, group, lArray);
        if (h5Group != null) {
            group.addToMemberList(h5Group);
        }
        return h5Group;
    }

    @Override
    public void setName(String string) throws Exception {
        String string2 = this.getPath() + this.getName();
        String string3 = this.getPath() + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Gmove(this.getFID(), string2, string3);
        super.setName(string);
    }

    @Override
    public void setPath(String string) throws Exception {
        super.setPath(string);
        List list = this.getMemberList();
        if (list == null) {
            return;
        }
        int n = list.size();
        HObject hObject = null;
        for (int i = 0; i < n; ++i) {
            hObject = (HObject)list.get(i);
            hObject.setPath(this.getPath() + this.getName() + "/");
        }
    }
}

