/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;

public abstract class FileFormat
extends File {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int CREATE = 2;
    public static final int FILE_CREATE_DELETE = 10;
    public static final int FILE_CREATE_OPEN = 11;
    public static final String FILE_TYPE_HDF4 = "HDF4";
    public static final String FILE_TYPE_HDF5 = "HDF5";
    public static final String FILE_OBJ_SEP = "#//";
    private static final Map<String, FileFormat> FileList;
    private static String extensions;
    private int max_members = 10000;
    private int start_members = 0;
    protected int fid = -1;
    protected String fullFileName = null;
    protected boolean isReadOnly = false;

    public FileFormat(String string) {
        super(string);
        this.fullFileName = string;
        if (string != null && string.length() > 0) {
            try {
                this.fullFileName = this.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isReadOnly = false;
    }

    public static final void addFileFormat(String string, FileFormat fileFormat) {
        if (fileFormat == null || string == null) {
            return;
        }
        if (!FileList.containsKey(string = string.trim())) {
            FileList.put(string, fileFormat);
        }
    }

    public static final FileFormat getFileFormat(String string) {
        return FileList.get(string);
    }

    public static final Enumeration getFileFormatKeys() {
        return ((Hashtable)FileList).keys();
    }

    public static final FileFormat[] getFileFormats() {
        int n = FileList.size();
        if (n <= 0) {
            return null;
        }
        int n2 = 0;
        FileFormat[] fileFormatArray = new FileFormat[n];
        Enumeration enumeration = ((Hashtable)FileList).elements();
        while (enumeration.hasMoreElements()) {
            fileFormatArray[n2++] = (FileFormat)enumeration.nextElement();
        }
        return fileFormatArray;
    }

    public static final FileFormat removeFileFormat(String string) {
        return FileList.remove(string);
    }

    public static final void addFileExtension(String string) {
        if (extensions == null || extensions.length() <= 0) {
            extensions = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(extensions, ",");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens() + 5);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
        stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim().toLowerCase();
            if (vector.contains(string2)) continue;
            extensions = extensions + ", " + string2;
        }
        vector.setSize(0);
    }

    public static final String getFileExtensions() {
        return extensions;
    }

    public static final FileFormat getInstance(String string) throws Exception {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("Invalid file name: " + string);
        }
        if (!new File(string).exists()) {
            throw new IllegalArgumentException("File " + string + " does not exist.");
        }
        FileFormat fileFormat = null;
        FileFormat fileFormat2 = null;
        Enumeration enumeration = ((Hashtable)FileList).elements();
        while (enumeration.hasMoreElements()) {
            fileFormat2 = (FileFormat)enumeration.nextElement();
            if (!fileFormat2.isThisType(string)) continue;
            try {
                fileFormat = fileFormat2.createInstance(string, 1);
            }
            catch (Exception exception) {}
            break;
        }
        return fileFormat;
    }

    public abstract String getLibversion();

    public abstract boolean isThisType(FileFormat var1);

    public abstract boolean isThisType(String var1);

    public FileFormat createFile(String string, int n) throws Exception {
        throw new UnsupportedOperationException("FileFormat FileFormat.createFile(...) is not implemented.");
    }

    public abstract FileFormat createInstance(String var1, int var2) throws Exception;

    public final String getFilePath() {
        return this.fullFileName;
    }

    public final int getFID() {
        return this.fid;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final void setMaxMembers(int n) {
        this.max_members = n;
    }

    public final int getMaxMembers() {
        return this.max_members;
    }

    public final void setStartMembers(int n) {
        this.start_members = n;
    }

    public final int getStartMembers() {
        return this.start_members;
    }

    public final int getNumberOfMembers() {
        int n = 0;
        TreeNode treeNode = this.getRootNode();
        if (treeNode != null) {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeNode).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
        }
        return n;
    }

    public abstract int open() throws Exception;

    public abstract void close() throws Exception;

    public abstract TreeNode getRootNode();

    public abstract HObject get(String var1) throws Exception;

    public abstract Datatype createDatatype(int var1, int var2, int var3, int var4, String var5) throws Exception;

    public abstract Datatype createDatatype(int var1, int var2, int var3, int var4) throws Exception;

    public abstract Dataset createScalarDS(String var1, Group var2, Datatype var3, long[] var4, long[] var5, long[] var6, int var7, Object var8) throws Exception;

    public Dataset createCompoundDS(String string, Group group, long[] lArray, long[] lArray2, long[] lArray3, int n, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        throw new UnsupportedOperationException("Dataset FileFormat.createCompoundDS(...) is not implemented.");
    }

    public abstract Dataset createImage(String var1, Group var2, Datatype var3, long[] var4, long[] var5, long[] var6, int var7, int var8, int var9, Object var10) throws Exception;

    public abstract Group createGroup(String var1, Group var2) throws Exception;

    public abstract HObject createLink(Group var1, String var2, HObject var3) throws Exception;

    public abstract TreeNode copy(HObject var1, Group var2, String var3) throws Exception;

    public abstract void delete(HObject var1) throws Exception;

    public abstract void writeAttribute(HObject var1, Attribute var2, boolean var3) throws Exception;

    @Deprecated
    public final FileFormat create(String string) throws Exception {
        return this.createFile(string, 10);
    }

    @Deprecated
    public final FileFormat open(String string, int n) throws Exception {
        return this.createInstance(string, n);
    }

    @Deprecated
    public final Dataset createCompoundDS(String string, Group group, long[] lArray, String[] stringArray, Datatype[] datatypeArray, int[] nArray, Object object) throws Exception {
        return this.createCompoundDS(string, group, lArray, null, null, -1, stringArray, datatypeArray, nArray, object);
    }

    @Deprecated
    public final TreeNode copy(HObject hObject, Group group) throws Exception {
        return this.copy(hObject, group, null);
    }

    @Deprecated
    public static final HObject getHObject(String string) throws Exception {
        if (string == null || string.length() <= 0) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(FILE_OBJ_SEP);
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + FILE_OBJ_SEP.length());
            if (string3 == null || string3.length() == 0) {
                string3 = "/";
            }
        } else {
            string2 = string;
            string3 = "/";
        }
        return FileFormat.getHObject(string2, string3);
    }

    @Deprecated
    public static final HObject getHObject(String string, String string2) throws Exception {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("Invalid file name. " + string);
        }
        if (!new File(string).exists()) {
            throw new IllegalArgumentException("File does not exists");
        }
        HObject hObject = null;
        FileFormat fileFormat = FileFormat.getInstance(string);
        if (fileFormat != null && (hObject = fileFormat.get(string2)) == null) {
            fileFormat.close();
        }
        return hObject;
    }

    public static final HObject findObject(FileFormat fileFormat, long[] lArray) {
        if (fileFormat == null || lArray == null) {
            return null;
        }
        HObject hObject = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        MutableTreeNode mutableTreeNode = (MutableTreeNode)fileFormat.getRootNode();
        if (mutableTreeNode == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)mutableTreeNode).breadthFirstEnumeration();
        while (enumeration.hasMoreElements() && !(hObject = (HObject)(defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()).equalsOID(lArray)) {
        }
        return hObject;
    }

    public static final HObject findObject(FileFormat fileFormat, String string) {
        String string2;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (fileFormat == null || string == null) {
            return null;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((defaultMutableTreeNode = (DefaultMutableTreeNode)fileFormat.getRootNode()) == null) {
            return null;
        }
        if (string.equals("/")) {
            return (HObject)defaultMutableTreeNode.getUserObject();
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        HObject hObject = null;
        while (enumeration.hasMoreElements() && !string.equals(string2 = (hObject = (HObject)(defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()).getFullName() + "/")) {
            hObject = null;
        }
        return hObject;
    }

    static {
        FileFormat fileFormat;
        Class<?> clazz;
        FileList = new Hashtable<String, FileFormat>(10);
        extensions = "hdf, h4, hdf5, h5";
        if (FileFormat.getFileFormat(FILE_TYPE_HDF4) == null) {
            try {
                clazz = Class.forName("ncsa.hdf.object.h4.H4File");
                fileFormat = (FileFormat)clazz.newInstance();
                if (fileFormat != null) {
                    FileFormat.addFileFormat(FILE_TYPE_HDF4, fileFormat);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (FileFormat.getFileFormat(FILE_TYPE_HDF5) == null) {
            try {
                clazz = Class.forName("ncsa.hdf.object.h5.H5File");
                fileFormat = (FileFormat)clazz.newInstance();
                if (fileFormat != null) {
                    FileFormat.addFileFormat(FILE_TYPE_HDF5, fileFormat);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

