/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform;

import org.glassfish.websocket.api.Peer;
import java.util.*;
import java.io.IOException;
import javax.servlet.http.*;
/**
 *
 * @author dannycoward delete this one
 */
 class ConversationImpl {
    private Set<Peer> remotes = new HashSet<Peer>();
    private org.glassfish.grizzly.websockets.WebSocket socket;
    private Long id;
    private Map properties = new HashMap();
    private boolean isValid = true;
    private HttpSession httpSession;

    ConversationImpl(org.glassfish.grizzly.websockets.WebSocket socket, Long id, HttpSession httpSession) {
        this.socket = socket;
        this.id = id;
        this.httpSession = httpSession;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public boolean isValid() {
        if (!socket.isConnected()) {
            isValid = false;
        }
        return isValid;
    }

    public void expire() throws IOException {
        this.socket.close();
        this.properties = new HashMap();
        this.setValid(false);

    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Long getSessionID() {
        return id;
    }

    public Set<Peer> getRemotes() {
        return remotes;
    }

    public Peer getRemote(Class c) {
        for (Peer nextRemote : remotes) {
            if (nextRemote.getClass().equals(c)) {
                return nextRemote;
            }
            Class[] interfaces = nextRemote.getClass().getInterfaces();
            for (Class ifc : interfaces) {
                if (ifc.equals(c)) {
                    return nextRemote;
                }
            }

        }
        return null;
    }

    public String toString() {
        return "Session"+id+"("+remotes+";"+this.properties+")";
    }

    void addRemote(Peer remote) {
        this.remotes.add(remote);
    }
    org.glassfish.grizzly.websockets.WebSocket getWebSocket() {
        return this.socket;
    }


}
