/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class PluginUtil {
    private static final Logger logger = Logger.getLogger("maven-embedded-glassfish-plugin");
    static GlassFishRuntime gfr;
    private static final Map<String, GlassFish> gfMap;

    public static GlassFish startGlassFish(String serverId, ClassLoader bootstrapClassLoader, Properties bootstrapProperties, Properties glassfishProperties) throws Exception {
        GlassFish gf = PluginUtil.getGlassFish(serverId, bootstrapClassLoader, bootstrapProperties, glassfishProperties);
        if (gf.getStatus() != GlassFish.Status.STARTED) {
            long startTime = System.currentTimeMillis();
            gf.start();
            logger.logp(Level.INFO, "PluginUtil", "startGlassFish", "Started GlassFish ServerId = {0}, GlassFish = {1}, TimeTaken = {2} ms", new Object[]{serverId, gf, System.currentTimeMillis() - startTime});
        }
        return gf;
    }

    public static void stopGlassFish(String serverId) throws Exception {
        GlassFish gf = gfMap.remove(serverId);
        if (gf != null && gf.getStatus().equals((Object)GlassFish.Status.STARTED)) {
            gf.stop();
            if (gfr != null) {
                gfr.shutdown();
            }
        }
        logger.logp(Level.INFO, "PluginUtil", "stopGlassFish", "Stopped GlassFish ServerId = {0}, GlassFish = {1}", new Object[]{serverId, gf});
    }

    public static void doDeploy(String serverId, ClassLoader cl, Properties bootstrapProperties, Properties glassfishProperties, File archive, String[] deploymentParameters) throws Exception {
        GlassFish gf = PluginUtil.startGlassFish(serverId, cl, bootstrapProperties, glassfishProperties);
        Deployer deployer = (Deployer)gf.getService(Deployer.class);
        logger.logp(Level.FINE, "PluginUtil", "doDeploy", "Deployer = {0}", deployer);
        String name = deployer.deploy(archive.toURI(), deploymentParameters);
        logger.logp(Level.INFO, "PluginUtil", "doDeploy", "Deployed {0}", name);
    }

    public static void doUndeploy(String serverId, ClassLoader bootstrapClassLoader, Properties bootstrapProperties, Properties glassfishProperties, String appName, String[] deploymentParameters) {
        try {
            GlassFish gf = PluginUtil.startGlassFish(serverId, bootstrapClassLoader, bootstrapProperties, glassfishProperties);
            Deployer deployer = (Deployer)gf.getService(Deployer.class);
            logger.logp(Level.INFO, "PluginUtil", "doUndeploy", "Deployer = {0}", deployer);
            deployer.undeploy(appName, deploymentParameters);
            logger.logp(Level.INFO, "PluginUtil", "doUndeploy", "Undeployed {0}", appName);
        }
        catch (Exception ex) {
            logger.logp(Level.WARNING, "PluginUtil", "doUndeploy", "Unable to undeploy {0}. Exception = {1}", new Object[]{appName, ex.getMessage()});
        }
    }

    private static GlassFish getGlassFish(String serverId, ClassLoader bootstrapClassLoader, Properties bootstrapProperties, Properties glassfishProperties) throws Exception {
        GlassFish gf = gfMap.get(serverId);
        if (gf == null) {
            long startTime = System.currentTimeMillis();
            logger.logp(Level.FINE, "PluginUtil", "getGlassFish", "Creating GlassFish ServerId = {0}", serverId);
            BootstrapProperties bootstrapOptions = new BootstrapProperties(bootstrapProperties);
            gfr = gfr != null ? gfr : GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapOptions, (ClassLoader)bootstrapClassLoader);
            logger.logp(Level.FINE, "PluginUtil", "getGlassFish", "Created GlassFishRuntime ServerId = {0}, GlassFishRuntime = {1}, TimeTaken = {2} ms", new Object[]{serverId, gfr, System.currentTimeMillis() - startTime});
            GlassFishProperties gfOptions = new GlassFishProperties(glassfishProperties);
            gf = gfr.newGlassFish(gfOptions);
            logger.logp(Level.INFO, "PluginUtil", "getGlassFish", "Created GlassFish ServerId = {0}, BootstrapProperties = {1}, GlassFishRuntime = {2}, GlassFishProperties = {3}, GlassFish = {4}, GlassFish Status = {5}, TimeTaken = {6} ms", new Object[]{serverId, bootstrapProperties, gfr, glassfishProperties, gf, gf.getStatus(), System.currentTimeMillis() - startTime});
            gfMap.put(serverId, gf);
        }
        return gf;
    }

    public static void runCommand(String serverId, String[] commandLines) throws Exception {
        GlassFish gf = gfMap.get(serverId);
        if (gf != null) {
            CommandRunner cr = (CommandRunner)gf.getService(CommandRunner.class);
            for (String commandLine : commandLines) {
                String[] split = commandLine.split(" ");
                String command = split[0].trim();
                String[] commandParams = null;
                if (split.length > 1) {
                    commandParams = new String[split.length - 1];
                    for (int i = 1; i < split.length; ++i) {
                        commandParams[i - 1] = split[i].trim();
                    }
                }
                try {
                    CommandResult result = commandParams == null ? cr.run(command, new String[0]) : cr.run(command, commandParams);
                    logger.logp(Level.INFO, "PluginUtil", "runCommand", "Ran command [{0}]. Exit Code [{1}], Output = [{2}]", new Object[]{commandLine, result.getExitStatus(), result.getOutput()});
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
    }

    static {
        logger.setLevel(Level.FINE);
        gfMap = new HashMap<String, GlassFish>();
    }
}

