/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodUtilities;
import freemarker.ext.beans.OverloadedMethod;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class OverloadedVarArgMethod
extends OverloadedMethod {
    private static final Map canoncialArgPackers = new HashMap();
    private final Map argPackers = new HashMap();

    OverloadedVarArgMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAddSignature(Member member, Class[] argTypes) {
        ArgumentPacker argPacker = new ArgumentPacker(argTypes);
        Map map = canoncialArgPackers;
        synchronized (map) {
            ArgumentPacker canonical = (ArgumentPacker)canoncialArgPackers.get(argPacker);
            if (canonical == null) {
                canoncialArgPackers.put(argPacker, argPacker);
            } else {
                argPacker = canonical;
            }
        }
        this.argPackers.put(member, argPacker);
        OverloadedVarArgMethod.componentizeLastType(argTypes);
    }

    void updateSignature(int l) {
        Class[] oneLongerTypes;
        Class[][] marshalTypes = this.getMarshalTypes();
        Class[] newTypes = marshalTypes[l];
        int i = l;
        while (i-- > 0) {
            Class[] previousTypes = marshalTypes[i];
            if (previousTypes == null) continue;
            OverloadedVarArgMethod.varArgUpdate(newTypes, previousTypes);
            break;
        }
        if (l + 1 < marshalTypes.length && (oneLongerTypes = marshalTypes[l + 1]) != null) {
            OverloadedVarArgMethod.varArgUpdate(newTypes, oneLongerTypes);
        }
    }

    void afterSignatureAdded(int l) {
        Class[] oneShorterTypes;
        Class[][] marshalTypes = this.getMarshalTypes();
        Class[] newTypes = marshalTypes[l];
        for (int i = l + 1; i < marshalTypes.length; ++i) {
            Class[] existingTypes = marshalTypes[i];
            if (existingTypes == null) continue;
            OverloadedVarArgMethod.varArgUpdate(existingTypes, newTypes);
        }
        if (l > 0 && (oneShorterTypes = marshalTypes[l - 1]) != null) {
            OverloadedVarArgMethod.varArgUpdate(oneShorterTypes, newTypes);
        }
    }

    private static void varArgUpdate(Class[] modifiedTypes, Class[] modifyingTypes) {
        int dl = modifiedTypes.length;
        int gl = modifyingTypes.length;
        int min = Math.min(gl, dl);
        for (int i = 0; i < min; ++i) {
            modifiedTypes[i] = MethodUtilities.getMostSpecificCommonType(modifiedTypes[i], modifyingTypes[i]);
        }
        if (dl > gl) {
            Class varArgType = modifyingTypes[gl - 1];
            for (int i = gl; i < dl; ++i) {
                modifiedTypes[i] = MethodUtilities.getMostSpecificCommonType(modifiedTypes[i], varArgType);
            }
        }
    }

    private static void componentizeLastType(Class[] types) {
        int l1 = types.length - 1;
        types[l1] = types[l1].getComponentType();
    }

    Object getMemberAndArguments(List arguments, BeansWrapper w) throws TemplateModelException {
        Object objMember;
        if (arguments == null) {
            arguments = Collections.EMPTY_LIST;
        }
        int l = arguments.size();
        Class[][] marshalTypes = this.getMarshalTypes();
        Object[] args = new Object[l];
        block0: for (int j = Math.min(l + 1, marshalTypes.length - 1); j >= 0; --j) {
            Class[] types = marshalTypes[j];
            if (types == null) {
                if (j != 0) continue;
                return NO_SUCH_METHOD;
            }
            Iterator it = arguments.iterator();
            for (int i = 0; i < l; ++i) {
                Object dst = w.unwrapInternal((TemplateModel)it.next(), i < j ? types[i] : types[j - 1]);
                if (dst == BeansWrapper.CAN_NOT_UNWRAP) continue block0;
                if (dst == args[i]) continue;
                args[i] = dst;
            }
        }
        if ((objMember = this.getMemberForArgs(args, true)) instanceof Member) {
            Member member = (Member)objMember;
            args = ((ArgumentPacker)this.argPackers.get(member)).packArgs(args, arguments, w);
            if (args == null) {
                return NO_SUCH_METHOD;
            }
            BeansWrapper.coerceBigDecimals(this.getSignature(member), args);
            return new MemberAndArguments(member, args);
        }
        return objMember;
    }

    private static class ArgumentPacker {
        private final int argCount;
        private final Class varArgType;

        ArgumentPacker(Class[] argTypes) {
            this.argCount = argTypes.length;
            this.varArgType = argTypes[this.argCount - 1].getComponentType();
        }

        Object[] packArgs(Object[] args, List modelArgs, BeansWrapper w) throws TemplateModelException {
            int actualArgCount = args.length;
            int fixArgCount = this.argCount - 1;
            if (args.length != this.argCount) {
                Object[] newargs = new Object[this.argCount];
                System.arraycopy(args, 0, newargs, 0, fixArgCount);
                Object array = Array.newInstance(this.varArgType, actualArgCount - fixArgCount);
                for (int i = fixArgCount; i < actualArgCount; ++i) {
                    Object val = w.unwrapInternal((TemplateModel)modelArgs.get(i), this.varArgType);
                    if (val == BeansWrapper.CAN_NOT_UNWRAP) {
                        return null;
                    }
                    Array.set(array, i - fixArgCount, val);
                }
                newargs[fixArgCount] = array;
                return newargs;
            }
            Object val = w.unwrap((TemplateModel)modelArgs.get(fixArgCount), this.varArgType);
            if (val == BeansWrapper.CAN_NOT_UNWRAP) {
                return null;
            }
            Object array = Array.newInstance(this.varArgType, 1);
            Array.set(array, 0, val);
            args[fixArgCount] = array;
            return args;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArgumentPacker) {
                ArgumentPacker p = (ArgumentPacker)obj;
                return this.argCount == p.argCount && this.varArgType == p.varArgType;
            }
            return false;
        }

        public int hashCode() {
            return this.argCount ^ this.varArgType.hashCode();
        }
    }
}

