/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public abstract class RestClientBuilderResolver {
    private static volatile RestClientBuilderResolver instance = null;

    protected RestClientBuilderResolver() {
    }

    public abstract RestClientBuilder newBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestClientBuilderResolver instance() {
        if (instance != null) return instance;
        Class<RestClientBuilderResolver> clazz = RestClientBuilderResolver.class;
        synchronized (RestClientBuilderResolver.class) {
            RestClientBuilderResolver newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            PrivilegedAction<ClassLoader> action = () -> Thread.currentThread().getContextClassLoader();
            ClassLoader cl = AccessController.doPrivileged(action);
            if (cl == null) {
                cl = RestClientBuilderResolver.class.getClassLoader();
            }
            if ((newInstance = RestClientBuilderResolver.loadSpi(cl)) == null) {
                throw new IllegalStateException("No RestClientBuilderResolver implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static RestClientBuilderResolver loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        RestClientBuilderResolver resolver = RestClientBuilderResolver.loadSpi(cl.getParent());
        if (resolver == null) {
            ServiceLoader<RestClientBuilderResolver> sl = ServiceLoader.load(RestClientBuilderResolver.class, cl);
            for (RestClientBuilderResolver spi : sl) {
                if (resolver != null) {
                    throw new IllegalStateException("Multiple RestClientBuilderResolver implementations found: " + spi.getClass().getName() + " and " + resolver.getClass().getName());
                }
                resolver = spi;
            }
        }
        return resolver;
    }

    public static void setInstance(RestClientBuilderResolver resolver) {
        instance = resolver;
    }
}

