/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class WebSocketServerConnection
extends AbstractWebSocketConnection {
    private final WebSocketServerFactory factory;
    private boolean connected;

    public WebSocketServerConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool, WebSocketServerFactory factory) {
        super(endp, executor, scheduler, policy, bufferPool);
        this.factory = factory;
        this.connected = false;
    }

    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            this.factory.sessionOpened(this.getSession());
            this.connected = true;
        }
        super.onOpen();
    }

    public void onWriteWebSocketClose() {
        this.disconnect();
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

