/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.Config;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Monitor;
import org.eclipse.jetty.start.log.RedirectedStreamLogger;

public class Main {
    private boolean _showUsage = false;
    private boolean _dumpVersions = false;
    private boolean _listOptions = false;
    private boolean _dryRun = false;
    private boolean _exec = false;
    private boolean _secure = false;
    private boolean _fromDaemon = false;
    private final Config _config = new Config();
    private Set<String> _sysProps = new HashSet<String>();
    private List<String> _xArgs = new ArrayList<String>();
    private String _jettyHome;

    public static void main(String[] args) {
        Main main = new Main();
        try {
            main.parseCommandLine(args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public void parseCommandLine(String[] args) {
        try {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.addAll(this.loadStartIni());
            if (args.length > 0) {
                arguments.addAll(Arrays.asList(args));
            }
            ArrayList<String> xmls = new ArrayList<String>();
            block10: for (String arg : arguments) {
                String[] assign;
                if ("--help".equals(arg)) {
                    this._showUsage = true;
                    continue;
                }
                if ("--stop".equals(arg)) {
                    int port = Integer.parseInt(this._config.getProperty("STOP.KEY", System.getProperty("STOP.PORT", "-1")));
                    String key = this._config.getProperty("STOP.KETY", System.getProperty("STOP.KEY", null));
                    this.stop(port, key);
                    return;
                }
                if ("--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
                    this._dumpVersions = true;
                    continue;
                }
                if ("--list-modes".equals(arg) || "--list-options".equals(arg)) {
                    this._listOptions = true;
                    continue;
                }
                if ("--exec-print".equals(arg) || "--dry-run".equals(arg)) {
                    this._dryRun = true;
                    continue;
                }
                if ("--exec".equals(arg)) {
                    this._exec = true;
                    continue;
                }
                if ("--fromDaemon".equals(arg)) {
                    this._fromDaemon = true;
                    PrintStream logger = new PrintStream(new RedirectedStreamLogger("daemon_yyyy_mm_dd.log", false, 90, TimeZone.getTimeZone("GMT")));
                    System.setOut(logger);
                    System.setErr(logger);
                    continue;
                }
                if ("--secure".equals(arg)) {
                    this._secure = true;
                    continue;
                }
                if (arg.startsWith("-X")) {
                    this._xArgs.add(arg);
                    continue;
                }
                if (arg.startsWith("-D")) {
                    assign = arg.substring(2).split("=", 2);
                    this._sysProps.add(assign[0]);
                    switch (assign.length) {
                        case 2: {
                            System.setProperty(assign[0], assign[1]);
                            continue block10;
                        }
                        case 1: {
                            System.setProperty(assign[0], "");
                            continue block10;
                        }
                    }
                    continue;
                }
                if (arg.indexOf(61) >= 0) {
                    assign = arg.split("=", 2);
                    switch (assign.length) {
                        case 2: {
                            this._config.setProperty(assign[0], assign[1]);
                            continue block10;
                        }
                        case 1: {
                            this._config.setProperty(assign[0], null);
                            continue block10;
                        }
                    }
                    continue;
                }
                xmls.add(arg);
            }
            String options = this._config.getProperty("OPTIONS");
            if (options != null) {
                String[] ids;
                for (String id : ids = options.split(",")) {
                    this._config.addActiveOption(id);
                }
            }
            this.start(xmls);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.out.println("Use java -jar start.jar --help for usage information.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadStartIni() {
        ArrayList<String> args;
        block7: {
            File startIniFile;
            String jettyHome = System.getProperty("jetty.home");
            File file = startIniFile = jettyHome != null ? new File(jettyHome, "start.ini") : new File("start.ini");
            if (!startIniFile.exists() || !startIniFile.canRead()) {
                return Collections.emptyList();
            }
            args = new ArrayList<String>();
            FileReader reader = null;
            BufferedReader buf = null;
            try {
                String arg;
                reader = new FileReader(startIniFile);
                buf = new BufferedReader(reader);
                while ((arg = buf.readLine()) != null) {
                    if ((arg = arg.trim()).length() == 0 || arg.startsWith("#")) continue;
                    args.add(arg);
                }
                Main.close(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Main.close(buf);
                Main.close(reader);
            }
            Main.close(reader);
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usage() {
        String usageResource = "org/eclipse/jetty/start/usage.txt";
        InputStream usageStream = this.getClass().getClassLoader().getResourceAsStream(usageResource);
        if (usageStream == null) {
            System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
            System.err.println("ERROR: detailed usage resource unavailable");
            System.exit(1);
        }
        BufferedReader buf = null;
        try {
            String line;
            buf = new BufferedReader(new InputStreamReader(usageStream));
            while ((line = buf.readLine()) != null) {
                if (line.startsWith("@OPTIONS@")) {
                    ArrayList<String> sortedOptions = new ArrayList<String>();
                    sortedOptions.addAll(this._config.getSectionIds());
                    Collections.sort(sortedOptions);
                    System.err.println("      Available OPTIONS: ");
                    for (String option : sortedOptions) {
                        System.err.println("         [" + option + "]");
                    }
                    continue;
                }
                if (line.startsWith("@CONFIGS@")) {
                    System.err.println("    Configurations Available in ${jetty.home}/etc/: ");
                    File etc = new File(System.getProperty("jetty.home", "."), "etc");
                    if (!etc.exists()) {
                        System.err.println("      Unable to find " + etc);
                        continue;
                    }
                    if (!etc.isDirectory()) {
                        System.err.println("      Unable list dir " + etc);
                        continue;
                    }
                    File[] configs = etc.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File path) {
                            if (!path.isFile()) {
                                return false;
                            }
                            String name = path.getName().toLowerCase();
                            return name.startsWith("jetty") && name.endsWith(".xml");
                        }
                    });
                    ArrayList<File> configFiles = new ArrayList<File>();
                    configFiles.addAll(Arrays.asList(configs));
                    Collections.sort(configFiles);
                    for (File configFile : configFiles) {
                        System.err.println("         etc/" + configFile.getName());
                    }
                    continue;
                }
                System.err.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (IOException ignore) {}
            }
        }
        System.exit(1);
    }

    public void invokeMain(ClassLoader classloader, String classname, List<String> args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = null;
        try {
            invoked_class = classloader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (Config.isDebug() || invoked_class == null) {
            if (invoked_class == null) {
                System.err.println("ClassNotFound: " + classname);
            } else {
                System.err.println(classname + " " + invoked_class.getPackage().getImplementationVersion());
            }
            if (invoked_class == null) {
                this.usage();
                return;
            }
        }
        String[] argArray = args.toArray(new String[0]);
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        main.invoke(null, method_params);
    }

    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start(List<String> xmls) throws FileNotFoundException, IOException, InterruptedException {
        this.startMonitor();
        List<String> configuredXmls = this.loadConfig(xmls);
        if (configuredXmls.isEmpty()) {
            throw new FileNotFoundException("No XML configuration files specified in start.config or command line.");
        }
        if (this._fromDaemon) {
            configuredXmls.add("etc/jetty-logging.xml");
        }
        if (this._secure) {
            this._config.addActiveOption("policy");
            this._config.addActiveOption("security");
        }
        configuredXmls = this.resolveXmlConfigs(configuredXmls);
        Classpath classpath = this._config.getActiveClasspath();
        System.setProperty("java.class.path", classpath.toString());
        ClassLoader cl = classpath.getClassLoader();
        if (Config.isDebug()) {
            System.err.println("java.class.path=" + System.getProperty("java.class.path"));
            System.err.println("jetty.home=" + System.getProperty("jetty.home"));
            System.err.println("java.home=" + System.getProperty("java.home"));
            System.err.println("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
            System.err.println("java.class.path=" + classpath);
            System.err.println("classloader=" + cl);
            System.err.println("classloader.parent=" + cl.getParent());
        }
        if (this._showUsage) {
            this.usage();
            return;
        }
        if (this._dumpVersions) {
            this.showClasspathWithVersions(classpath);
            this.showActiveSecurityPolicies(cl);
            return;
        }
        if (this._listOptions) {
            this.showAllOptionsWithVersions(classpath);
            return;
        }
        if (this._dryRun) {
            System.out.println(this.buildCommandLine(classpath, configuredXmls));
            return;
        }
        if (this._exec) {
            String cmd = this.buildCommandLine(classpath, configuredXmls);
            Process process = Runtime.getRuntime().exec(cmd);
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            return;
        }
        if (this._xArgs.size() > 0 || this._sysProps.size() > 0) {
            System.err.println("WARNING: System properties and/or JVM args set.  Consider using --dry-run or --exec");
        }
        Thread.currentThread().setContextClassLoader(cl);
        this.initSecurity(cl);
        try {
            String classname = this._config.getMainClassname();
            String mainClass = System.getProperty("jetty.server");
            if (mainClass != null) {
                classname = mainClass;
            }
            if ((mainClass = System.getProperty("main.class")) != null) {
                classname = mainClass;
            }
            Config.debug("main.class=" + classname);
            this.invokeMain(cl, classname, configuredXmls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private String resolveXmlConfig(String xmlFilename) throws FileNotFoundException {
        if (!xmlFilename.toLowerCase().endsWith(".xml")) {
            return xmlFilename;
        }
        File xml = new File(xmlFilename);
        if (xml.exists() && xml.isFile() && xml.isAbsolute()) {
            return xml.getAbsolutePath();
        }
        xml = new File(this._jettyHome, this.fixPath(xmlFilename));
        if (xml.exists() && xml.isFile()) {
            return xml.getAbsolutePath();
        }
        xml = new File(this._jettyHome, this.fixPath("etc/" + xmlFilename));
        if (xml.exists() && xml.isFile()) {
            return xml.getAbsolutePath();
        }
        throw new FileNotFoundException("Unable to find XML Config: " + xmlFilename);
    }

    private String buildCommandLine(Classpath classpath, List<String> xmls) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(this.findJavaBin());
        for (String x : this._xArgs) {
            cmd.append(' ').append(x);
        }
        cmd.append(" -Djetty.home=").append(this._jettyHome);
        for (String p : this._sysProps) {
            cmd.append(" -D").append(p);
            String v = System.getProperty(p);
            if (v == null) continue;
            cmd.append('=').append(v);
        }
        cmd.append(" -cp ").append(classpath.toString());
        cmd.append(' ').append(this._config.getMainClassname());
        for (String xml : xmls) {
            cmd.append(' ').append(xml);
        }
        return cmd.toString();
    }

    private String findJavaBin() {
        File javaHome = new File(System.getProperty("java.home"));
        if (!javaHome.exists()) {
            return null;
        }
        File javabin = this.findExecutable(javaHome, "bin/java");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        javabin = this.findExecutable(javaHome, "bin/java.exe");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    private File findExecutable(File root, String path) {
        String npath = path.replace('/', File.separatorChar);
        File exe = new File(root, npath);
        if (!exe.exists()) {
            return null;
        }
        return exe;
    }

    private void showAllOptionsWithVersions(Classpath classpath) {
        Set<String> sectionIds = this._config.getSectionIds();
        StringBuffer msg = new StringBuffer();
        msg.append("There ");
        if (sectionIds.size() > 1) {
            msg.append("are ");
        } else {
            msg.append("is ");
        }
        msg.append(String.valueOf(sectionIds.size()));
        msg.append(" OPTION");
        if (sectionIds.size() > 1) {
            msg.append("s");
        }
        msg.append(" available to use.");
        System.out.println(msg);
        System.out.println("Each option is listed along with associated available classpath entries,  in the order that they would appear from that mode.");
        System.out.println("Note: If using multiple options (eg: 'Server,servlet,webapp,jms,jmx') then overlapping entries will not be repeated in the eventual classpath.");
        System.out.println();
        System.out.printf("${jetty.home} = %s%n", this._jettyHome);
        System.out.println();
        for (String sectionId : sectionIds) {
            if ("".equals(sectionId)) {
                System.out.println("GLOBAL option (Prepended Entries)");
            } else if ("*".equals(sectionId)) {
                System.out.println("GLOBAL option (Appended Entries) (*)");
            } else {
                System.out.printf("Option [%s]", sectionId);
                if (Character.isUpperCase(sectionId.charAt(0))) {
                    System.out.print(" (Aggregate)");
                }
                System.out.println();
            }
            System.out.println("-------------------------------------------------------------");
            Classpath sectionCP = this._config.getSectionClasspath(sectionId);
            if (sectionCP.isEmpty()) {
                System.out.println("Empty option, no classpath entries active.");
                System.out.println();
                continue;
            }
            int i = 0;
            for (File element : sectionCP.getElements()) {
                String elementPath = element.getAbsolutePath();
                if (elementPath.startsWith(this._jettyHome)) {
                    elementPath = "${jetty.home}" + elementPath.substring(this._jettyHome.length());
                }
                System.out.printf("%2d: %20s | %s\n", i++, this.getVersion(element), elementPath);
            }
            System.out.println();
        }
    }

    private void showClasspathWithVersions(Classpath classpath) {
        System.out.println("Active Options: " + this._config.getActiveOptions());
        if (classpath.count() == 0) {
            System.out.println("No version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the OPTIONS=[option,option,...] command line option will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            String elementPath = element.getAbsolutePath();
            if (elementPath.startsWith(this._jettyHome)) {
                elementPath = "${jetty.home}" + elementPath.substring(this._jettyHome.length());
            }
            System.out.printf("%2d: %20s | %s\n", i++, this.getVersion(element), elementPath);
        }
    }

    private void showActiveSecurityPolicies(ClassLoader cl) {
        this.initSecurity(cl);
        Policy policy = Policy.getPolicy();
        if (policy != null && policy.getClass().getName().contains("JettyPolicy")) {
            System.out.println("Active Security Policies: ");
            try {
                Method m = policy.getClass().getMethod("dump", PrintStream.class);
                m.invoke((Object)policy, System.out);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String fixPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    private String getVersion(File element) {
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile()) {
            String name = element.getName().toLowerCase();
            if (name.endsWith(".jar")) {
                return JarVersion.getVersion(element);
            }
            if (name.endsWith(".zip")) {
                return this.getZipVersion(element);
            }
        }
        return "";
    }

    private String getZipVersion(File element) {
        return "";
    }

    private void initSecurity(ClassLoader cl) {
        try {
            if (this._secure) {
                Policy.setPolicy(this._config.getPolicyInstance(cl));
                System.setSecurityManager(new SecurityManager());
            } else {
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    policy.refresh();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> resolveXmlConfigs(List<String> xmls) throws FileNotFoundException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String xml : xmls) {
            ret.add(this.resolveXmlConfig(xml));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadConfig(List<String> xmls) {
        InputStream cfgstream = null;
        try {
            this._config.setArgCount(xmls.size());
            String cfgName = System.getProperty("START", "org/eclipse/jetty/start/start.config");
            Config.debug("config=" + cfgName);
            cfgstream = this.getClass().getClassLoader().getResourceAsStream(cfgName);
            if (cfgstream == null) {
                cfgstream = new FileInputStream(cfgName);
            }
            this._config.parse(cfgstream);
            this._jettyHome = this._config.getProperty("jetty.home");
            if (this._jettyHome != null) {
                this._jettyHome = new File(this._jettyHome).getCanonicalPath();
                System.setProperty("jetty.home", this._jettyHome);
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.addAll(xmls);
            for (String xmlconfig : this._config.getXmlConfigs()) {
                if (ret.contains(xmlconfig)) continue;
                ret.add(xmlconfig);
            }
            ArrayList<String> arrayList = ret;
            Main.close(cfgstream);
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            List<String> list = null;
            return list;
        }
        finally {
            Main.close(cfgstream);
        }
    }

    private void startMonitor() {
        int port = Integer.parseInt(System.getProperty("STOP.PORT", "-1"));
        String key = System.getProperty("STOP.KEY", null);
        Monitor.monitor(port, key);
    }

    public void stop(int port, String key) {
        int _port = port;
        String _key = key;
        try {
            if (_port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (_key == null) {
                _key = "";
                System.err.println("STOP.KEY system property must be specified");
                System.err.println("Using empty key");
            }
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), _port);
            OutputStream out = s.getOutputStream();
            out.write((_key + "\r\nstop\r\n").getBytes());
            out.flush();
            s.close();
        }
        catch (ConnectException e) {
            System.err.println("ERROR: Not running!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

