/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslSelectChannelEndPoint
extends SelectChannelEndPoint {
    static Logger __log = Log.getLogger((String)"org.eclipse.jetty.http.ssl");
    private static final ByteBuffer[] __NO_BUFFERS = new ByteBuffer[0];
    private final Buffers _buffers;
    private final SSLEngine _engine;
    private final SSLSession _session;
    private volatile NIOBuffer _inNIOBuffer;
    private volatile NIOBuffer _outNIOBuffer;
    private final ByteBuffer[] _gather = new ByteBuffer[2];
    private boolean _closing = false;
    private SSLEngineResult _result;
    private boolean _handshook = false;
    private boolean _allowRenegotiate = false;
    private final boolean _debug = __log.isDebugEnabled();

    public SslSelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws IOException {
        super(channel, selectSet, key);
        this._buffers = buffers;
        this._engine = engine;
        this._session = engine.getSession();
        if (this._debug) {
            __log.debug(this._session + " channel=" + channel, new Object[0]);
        }
    }

    private void needOutBuffer() {
        if (this._outNIOBuffer == null) {
            this._outNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
        }
    }

    private void needInBuffer() {
        if (this._inNIOBuffer == null) {
            this._inNIOBuffer = (NIOBuffer)this._buffers.getBuffer(this._session.getPacketBufferSize());
        }
    }

    private void freeOutBuffer() {
        if (this._outNIOBuffer.length() == 0) {
            this._buffers.returnBuffer(this._outNIOBuffer);
            this._outNIOBuffer = null;
        }
    }

    private void freeInBuffer() {
        if (this._inNIOBuffer.length() == 0) {
            this._buffers.returnBuffer(this._inNIOBuffer);
            this._inNIOBuffer = null;
        }
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    public void dump() {
        Log.info((String)("" + this._result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this._closing = true;
        long end = System.currentTimeMillis() + (long)((SocketChannel)this._channel).socket().getSoTimeout();
        try {
            if (this.isBufferingOutput()) {
                this.flush();
                while (this.isOpen() && this.isBufferingOutput() && System.currentTimeMillis() < end) {
                    Thread.sleep(100L);
                    this.flush();
                }
            }
            this._engine.closeOutbound();
            while (this.isOpen()) {
                if (this._engine.isInboundDone()) {
                    if (this._engine.isOutboundDone()) return;
                }
                if (System.currentTimeMillis() >= end) return;
                if (this.isBufferingOutput()) {
                    this.flush();
                    while (this.isOpen() && this.isBufferingOutput() && System.currentTimeMillis() < end) {
                        Thread.sleep(100L);
                        this.flush();
                    }
                }
                if (this._debug) {
                    __log.debug(this._session + " closing " + (Object)((Object)this._engine.getHandshakeStatus()), new Object[0]);
                }
                switch (this._engine.getHandshakeStatus()) {
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        this._handshook = true;
                        return;
                    }
                    case NEED_UNWRAP: {
                        Buffer buffer = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                        try {
                            ByteBuffer bbuffer = ((NIOBuffer)buffer).getByteBuffer();
                            if (!this.unwrap(bbuffer) && this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                                return;
                            }
                            break;
                        }
                        catch (SSLException e) {
                            Log.ignore((Throwable)e);
                            break;
                        }
                        finally {
                            this._buffers.returnBuffer(buffer);
                        }
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        break;
                    }
                    case NEED_WRAP: {
                        this.needOutBuffer();
                        ByteBuffer out_buffer = this._outNIOBuffer.getByteBuffer();
                        try {
                            this._outNIOBuffer.compact();
                            int put = this._outNIOBuffer.putIndex();
                            out_buffer.position(put);
                            this._result = null;
                            this._result = this._engine.wrap(__NO_BUFFERS, out_buffer);
                            if (this._debug) {
                                __log.debug(this._session + " close wrap " + this._result, new Object[0]);
                            }
                            this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                            break;
                        }
                        finally {
                            out_buffer.position(0);
                            this.freeOutBuffer();
                        }
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            Log.ignore((Throwable)e);
            return;
        }
        finally {
            super.close();
            if (this._inNIOBuffer != null) {
                this._buffers.returnBuffer(this._inNIOBuffer);
            }
            if (this._outNIOBuffer != null) {
                this._buffers.returnBuffer(this._outNIOBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int fill(Buffer buffer) throws IOException {
        bbuf = this.extractInputBuffer(buffer);
        size = buffer.length();
        initialStatus = this._engine.getHandshakeStatus();
        var5_5 = bbuf;
        synchronized (var5_5) {
            block31: {
                try {
                    this.unwrap(bbuf);
                    wraps = 0;
                    while (true) {
                        if (this.isBufferingOutput()) {
                            this.flush();
                            if (this.isBufferingOutput()) break;
                        }
                        switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this._engine.getHandshakeStatus().ordinal()]) {
                            case 1: 
                            case 2: {
                                if (this._closing) {
                                    var7_9 = -1;
                                    return var7_9;
                                }
                                break block31;
                            }
                            case 3: {
                                this.checkRenegotiate();
                                if (this.unwrap(bbuf) || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                                ** break;
lbl24:
                                // 1 sources

                                break block31;
                            }
                            case 4: {
                                while ((task = this._engine.getDelegatedTask()) != null) {
                                    task.run();
                                }
                                if (initialStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || wraps != 0) break;
                                if (this._debug) {
                                    SslSelectChannelEndPoint.__log.warn(this._session + " JETTY-567", new Object[0]);
                                }
                                var8_11 = -1;
                                return var8_11;
                            }
                            case 5: {
                                this.checkRenegotiate();
                                ++wraps;
                                this.needOutBuffer();
                                var8_10 = out_buffer = this._outNIOBuffer.getByteBuffer();
                                synchronized (var8_10) {
                                    try {
                                        this._outNIOBuffer.compact();
                                        put = this._outNIOBuffer.putIndex();
                                        out_buffer.position();
                                        this._result = null;
                                        this._result = this._engine.wrap(SslSelectChannelEndPoint.__NO_BUFFERS, out_buffer);
                                        if (this._debug) {
                                            SslSelectChannelEndPoint.__log.debug(this._session + " fill wrap " + this._result, new Object[0]);
                                        }
                                        switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[this._result.getStatus().ordinal()]) {
                                            case 1: 
                                            case 2: {
                                                Log.warn((String)"wrap {}", (Object)this._result);
                                            }
                                            case 3: {
                                                this._closing = true;
                                                break;
                                            }
                                        }
                                        this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                                    }
                                    finally {
                                        out_buffer.position(0);
                                    }
                                }
                                this.flush();
                                this.freeOutBuffer();
                            }
                        }
                    }
                }
                catch (SSLException e) {
                    Log.warn((String)e.toString());
                    Log.debug((Throwable)e);
                    throw e;
                }
                finally {
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                }
            }
            filled = buffer.length() - size;
            if (filled <= 0) return filled;
            this._handshook = true;
            return filled;
        }
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int consumed = 0;
        int available = header.length();
        if (buffer != null) {
            available += buffer.length();
        }
        this.needOutBuffer();
        ByteBuffer out_buffer = this._outNIOBuffer.getByteBuffer();
        block18: while (true) {
            if (this._outNIOBuffer.length() > 0) {
                this.flush();
                if (this.isBufferingOutput()) break;
            }
            switch (this._engine.getHandshakeStatus()) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    if (this._closing || available == 0) {
                        if (consumed != 0) break block18;
                        consumed = -1;
                        break block18;
                    }
                    int c = header != null && header.length() > 0 ? (buffer != null && buffer.length() > 0 ? this.wrap(header, buffer) : this.wrap(header)) : this.wrap(buffer);
                    if (c > 0) {
                        this._handshook = true;
                        consumed += c;
                        available -= c;
                        break;
                    }
                    if (c >= 0) break;
                    if (consumed != 0) break block18;
                    consumed = -1;
                    break block18;
                }
                case NEED_UNWRAP: {
                    this.checkRenegotiate();
                    Buffer buf = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                    try {
                        ByteBuffer bbuf = ((NIOBuffer)buf).getByteBuffer();
                        if (this.unwrap(bbuf) || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                        break block18;
                    }
                    finally {
                        this._buffers.returnBuffer(buf);
                    }
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this._engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    break;
                }
                case NEED_WRAP: {
                    this.checkRenegotiate();
                    ByteBuffer byteBuffer = out_buffer;
                    synchronized (byteBuffer) {
                        try {
                            this._outNIOBuffer.compact();
                            int put = this._outNIOBuffer.putIndex();
                            out_buffer.position();
                            this._result = null;
                            this._result = this._engine.wrap(__NO_BUFFERS, out_buffer);
                            if (this._debug) {
                                __log.debug(this._session + " flush wrap " + this._result, new Object[0]);
                            }
                            switch (this._result.getStatus()) {
                                case BUFFER_OVERFLOW: 
                                case BUFFER_UNDERFLOW: {
                                    Log.warn((String)"unwrap {}", (Object)this._result);
                                }
                                case CLOSED: {
                                    this._closing = true;
                                    break;
                                }
                            }
                            this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                        }
                        finally {
                            out_buffer.position(0);
                        }
                    }
                    this.flush();
                    if (this.isBufferingOutput()) break block18;
                }
            }
        }
        this.freeOutBuffer();
        return consumed;
    }

    public void flush() throws IOException {
        if (this._outNIOBuffer == null) {
            return;
        }
        int len = this._outNIOBuffer.length();
        if (this.isBufferingOutput()) {
            int flushed = super.flush(this._outNIOBuffer);
            if (this._debug) {
                __log.debug(this._session + " Flushed " + flushed + "/" + len, new Object[0]);
            }
            if (this.isBufferingOutput()) {
                Thread.yield();
                flushed = super.flush(this._outNIOBuffer);
                if (this._debug) {
                    __log.debug(this._session + " flushed " + flushed + "/" + len, new Object[0]);
                }
            }
        }
    }

    private void checkRenegotiate() throws IOException {
        if (this._handshook && !this._allowRenegotiate && this._channel != null && this._channel.isOpen()) {
            Log.warn((String)("SSL renegotiate denied: " + this._channel));
            this.close();
        }
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) {
        assert (buffer instanceof NIOBuffer);
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unwrap(ByteBuffer buffer) throws IOException {
        this.needInBuffer();
        ByteBuffer in_buffer = this._inNIOBuffer.getByteBuffer();
        if (this._inNIOBuffer.hasContent()) {
            this._inNIOBuffer.compact();
        } else {
            this._inNIOBuffer.clear();
        }
        int total_filled = 0;
        while (this._inNIOBuffer.space() > 0 && super.isOpen()) {
            try {
                int filled = super.fill(this._inNIOBuffer);
                if (this._debug) {
                    __log.debug(this._session + " unwrap filled " + filled, new Object[0]);
                }
                if (filled <= 0) break;
                total_filled += filled;
            }
            catch (IOException e) {
                if (this._inNIOBuffer.length() != 0) break;
                if (this._outNIOBuffer != null) {
                    this._outNIOBuffer.clear();
                    this.freeOutBuffer();
                }
                throw e;
            }
        }
        if (total_filled == 0 && this._inNIOBuffer.length() == 0) {
            if (!this.isOpen()) {
                if (this._outNIOBuffer != null) {
                    this._outNIOBuffer.clear();
                }
                throw new EofException();
            }
            return false;
        }
        try {
            in_buffer.position(this._inNIOBuffer.getIndex());
            in_buffer.limit(this._inNIOBuffer.putIndex());
            this._result = null;
            this._result = this._engine.unwrap(in_buffer, buffer);
            if (this._debug) {
                __log.debug(this._session + " unwrap unwrap " + this._result, new Object[0]);
            }
            this._inNIOBuffer.skip(this._result.bytesConsumed());
        }
        finally {
            in_buffer.position(0);
            in_buffer.limit(in_buffer.capacity());
            this.freeInBuffer();
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: {
                throw new IllegalStateException(this._result.toString() + " " + buffer.position() + " " + buffer.limit());
            }
            case BUFFER_UNDERFLOW: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"unwrap {}", (Object)this._result);
                }
                if (!this.isOpen()) {
                    this._inNIOBuffer.clear();
                    if (this._outNIOBuffer != null) {
                        this._outNIOBuffer.clear();
                    }
                    throw new EofException();
                }
                return total_filled > 0;
            }
            case CLOSED: {
                this._closing = true;
                return total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
            }
            case OK: {
                return total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
            }
        }
        Log.warn((String)("unwrap " + this._result));
        throw new IOException(this._result.toString());
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        return ByteBuffer.wrap(buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer header, Buffer buffer) throws IOException {
        this._gather[0] = this.extractOutputBuffer(header);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(header.getIndex());
            this._gather[0].limit(header.putIndex());
            this._gather[1] = this.extractOutputBuffer(buffer);
            ByteBuffer byteBuffer2 = this._gather[1];
            synchronized (byteBuffer2) {
                ByteBuffer out_buffer;
                this._gather[1].position(buffer.getIndex());
                this._gather[1].limit(buffer.putIndex());
                this.needOutBuffer();
                ByteBuffer byteBuffer3 = out_buffer = this._outNIOBuffer.getByteBuffer();
                synchronized (byteBuffer3) {
                    int len2;
                    int consumed = 0;
                    try {
                        this._outNIOBuffer.clear();
                        out_buffer.position(0);
                        out_buffer.limit(out_buffer.capacity());
                        this._result = null;
                        this._result = this._engine.wrap(this._gather, out_buffer);
                        if (this._debug) {
                            __log.debug(this._session + " wrap wrap " + this._result, new Object[0]);
                        }
                        this._outNIOBuffer.setGetIndex(0);
                        this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                        consumed = this._result.bytesConsumed();
                        Object var9_8 = null;
                        out_buffer.position(0);
                    }
                    catch (Throwable throwable) {
                        int len2;
                        Object var9_9 = null;
                        out_buffer.position(0);
                        if (consumed > 0) {
                            len2 = consumed < header.length() ? consumed : header.length();
                            header.skip(len2);
                            consumed -= len2;
                            this._gather[0].position(0);
                            this._gather[0].limit(this._gather[0].capacity());
                        }
                        if (consumed > 0) {
                            len2 = consumed < buffer.length() ? consumed : buffer.length();
                            buffer.skip(len2);
                            consumed -= len2;
                            this._gather[1].position(0);
                            this._gather[1].limit(this._gather[1].capacity());
                        }
                        assert (consumed == 0);
                        this.freeOutBuffer();
                        throw throwable;
                    }
                    if (consumed > 0) {
                        len2 = consumed < header.length() ? consumed : header.length();
                        header.skip(len2);
                        consumed -= len2;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    if (consumed > 0) {
                        len2 = consumed < buffer.length() ? consumed : buffer.length();
                        buffer.skip(len2);
                        consumed -= len2;
                        this._gather[1].position(0);
                        this._gather[1].limit(this._gather[1].capacity());
                    }
                    assert (consumed == 0);
                    this.freeOutBuffer();
                }
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn((String)"unwrap {}", (Object)this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn((String)("wrap " + this._result));
        throw new IOException(this._result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer buffer) throws IOException {
        this._gather[0] = this.extractOutputBuffer(buffer);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            ByteBuffer out_buffer;
            this._gather[0].position(buffer.getIndex());
            this._gather[0].limit(buffer.putIndex());
            int consumed = 0;
            this.needOutBuffer();
            ByteBuffer byteBuffer2 = out_buffer = this._outNIOBuffer.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    this._outNIOBuffer.clear();
                    out_buffer.position(0);
                    out_buffer.limit(out_buffer.capacity());
                    this._result = null;
                    this._result = this._engine.wrap(this._gather[0], out_buffer);
                    if (this._debug) {
                        __log.debug(this._session + " wrap wrap " + this._result, new Object[0]);
                    }
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                    consumed = this._result.bytesConsumed();
                    Object var8_6 = null;
                    out_buffer.position(0);
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    out_buffer.position(0);
                    if (consumed > 0) {
                        int len = consumed < buffer.length() ? consumed : buffer.length();
                        buffer.skip(len);
                        consumed -= len;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    assert (consumed == 0);
                    this.freeOutBuffer();
                    throw throwable;
                }
                if (consumed > 0) {
                    int len = consumed < buffer.length() ? consumed : buffer.length();
                    buffer.skip(len);
                    consumed -= len;
                    this._gather[0].position(0);
                    this._gather[0].limit(this._gather[0].capacity());
                }
                assert (consumed == 0);
                this.freeOutBuffer();
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn((String)"unwrap {}", (Object)this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn((String)("wrap " + this._result));
        throw new IOException(this._result.toString());
    }

    public boolean isBufferingInput() {
        NIOBuffer in = this._inNIOBuffer;
        return in == null ? false : this._inNIOBuffer.hasContent();
    }

    public boolean isBufferingOutput() {
        NIOBuffer b = this._outNIOBuffer;
        return b == null ? false : b.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }

    public String toString() {
        NIOBuffer i = this._inNIOBuffer;
        NIOBuffer o = this._outNIOBuffer;
        return super.toString() + "," + (Object)((Object)this._engine.getHandshakeStatus()) + ", in/out=" + (i == null ? 0 : this._inNIOBuffer.length()) + "/" + (o == null ? 0 : o.length()) + " " + this._result;
    }
}

