/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction0;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.IntBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.IntToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntBooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.IntBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntBooleanMap;
import org.eclipse.collections.api.map.primitive.IntBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableIntBooleanMap;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntBooleanPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.primitive.IntBooleanMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableBooleanValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedIntBooleanMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableIntBooleanMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class IntBooleanHashMap
extends AbstractMutableBooleanValuesMap
implements MutableIntBooleanMap,
MutableIntKeysMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private int[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableBooleanValuesMap.SentinelValues sentinelValues;

    public IntBooleanHashMap() {
        this.allocateTable(16);
    }

    public IntBooleanHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public IntBooleanHashMap(IntBooleanMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    @Deprecated
    public IntBooleanHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity);
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected boolean getEmptyValue() {
        return false;
    }

    @Override
    protected int getTableSize() {
        return this.keys.length;
    }

    @Override
    protected boolean getValueAtIndex(int index) {
        return this.values.get(index);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntBooleanHashMap.isEmptyKey(this.keys[index]) && !IntBooleanHashMap.isRemovedKey(this.keys[index]);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public MutableIntBooleanMap asUnmodifiable() {
        return new UnmodifiableIntBooleanMap(this);
    }

    public MutableIntBooleanMap asSynchronized() {
        return new SynchronizedIntBooleanMap(this);
    }

    public ImmutableIntBooleanMap toImmutable() {
        return IntBooleanMaps.immutable.withAll((IntBooleanMap)this);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1) {
        return new IntBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2) {
        return new IntBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3) {
        return new IntBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntBooleanHashMap newWithKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3, int key4, boolean value4) {
        return new IntBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public IntBooleanHashMap withKeyValue(int key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntBooleanHashMap withKeysValues(int key1, boolean value1, int key2, boolean value2, int key3, boolean value3, int key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntBooleanHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntBooleanHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntBooleanHashMap.isEmptyKey(key) && !IntBooleanHashMap.isRemovedKey(key);
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    public boolean trimToSize() {
        int newCapacity = this.smallestPowerOfTwoGreaterThan(this.size());
        if (this.keys.length > newCapacity) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Deprecated
    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(int element) {
        int index = this.spreadAndMask(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            int keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = Integer.reverse(SpreadFunctions.intSpreadOne(element));
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0);
        this.values.clear();
    }

    public void put(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.getSentinelValues() == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsZeroKey = true;
            this.getSentinelValues().zeroValue = value;
            return;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
            }
            this.getSentinelValues().containsOneKey = true;
            this.getSentinelValues().oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(IntBooleanMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(IntBooleanToBooleanFunction function) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf(0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf(1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            this.values.set(i, function.valueOf(this.keys[i], this.getValueAtIndex(i)));
        }
    }

    @Override
    public boolean containsKey(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsZeroKey;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            return this.getSentinelValues() != null && this.getSentinelValues().containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean get(int key) {
        return this.getIfAbsent(key, this.getEmptyValue());
    }

    public boolean getIfAbsent(int key, boolean ifAbsent) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return ifAbsent;
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.isNonSentinelAtIndex(index)) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPut(int key, BooleanFunction0 function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(int key, BooleanFunction<? super P> function, P parameter) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPutWithKey(int key, IntToBooleanFunction function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsZeroKey) {
                return this.getSentinelValues().zeroValue;
            }
            boolean value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.getSentinelValues().containsOneKey) {
                return this.getSentinelValues().oneValue;
            }
            boolean value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean updateValue(int key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsZeroKey) {
                this.getSentinelValues().zeroValue = function.valueOf(this.getSentinelValues().zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().zeroValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableBooleanValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.getSentinelValues().containsOneKey) {
                this.getSentinelValues().oneValue = function.valueOf(this.getSentinelValues().oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.getSentinelValues().oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(int key, boolean value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public void removeKey(int key) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(int key, boolean value) {
        if (IntBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsZeroKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.getSentinelValues().containsOneKey) {
                return value;
            }
            boolean oldValue = this.getSentinelValues().oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            boolean oldValue = this.values.get(index);
            this.values.set(index, this.getEmptyValue());
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntBooleanMap)) {
            return false;
        }
        IntBooleanMap other = (IntBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.getSentinelValues().containsZeroKey && (!other.containsKey(0) || this.getSentinelValues().zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && (!other.containsKey(1) || this.getSentinelValues().oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i) || other.containsKey(this.keys[i]) && this.getValueAtIndex(i) == other.getOrThrow(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0 ^ (this.getSentinelValues().zeroValue ? 1231 : 1237);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += 1 ^ (this.getSentinelValues().oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.getValueAtIndex(i) ? 1231 : 1237);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                appendable.append(0).append("=").append(this.getSentinelValues().zeroValue);
                first = false;
            }
            if (this.getSentinelValues().containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.getSentinelValues().oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.keys[i]).append("=").append(this.getValueAtIndex(i));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableBooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(0);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(1);
            }
        }
        for (int key : this.keys) {
            if (!IntBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(IntBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.getValueAtIndex(i));
        }
    }

    public IntBooleanHashMap select(IntBooleanPredicate predicate) {
        IntBooleanHashMap result = new IntBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0, this.getSentinelValues().zeroValue)) {
                result.put(0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1, this.getSentinelValues().oneValue)) {
                result.put(1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public IntBooleanHashMap reject(IntBooleanPredicate predicate) {
        IntBooleanHashMap result = new IntBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0, this.getSentinelValues().zeroValue)) {
                result.put(0, this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1, this.getSentinelValues().oneValue)) {
                result.put(1, this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.getValueAtIndex(i))) continue;
            result.put(this.keys[i], this.getValueAtIndex(i));
        }
        return result;
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public RichIterable<IntBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(0.5f);
        if (this.sentinelValues != null) {
            if (this.getSentinelValues().containsZeroKey) {
                out.writeInt(0);
                out.writeBoolean(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                out.writeInt(1);
                out.writeBoolean(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeBoolean(this.getValueAtIndex(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        in.readFloat();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readBoolean());
        }
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntBooleanHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<IntBooleanPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super IntBooleanPair> procedure) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, IntBooleanHashMap.this.getSentinelValues().zeroValue));
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, IntBooleanHashMap.this.getSentinelValues().oneValue));
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntBooleanHashMap.this.keys[i], IntBooleanHashMap.this.getValueAtIndex(i)));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntBooleanPair> objectIntProcedure) {
            int index = 0;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0, IntBooleanHashMap.this.getSentinelValues().zeroValue), index);
                    ++index;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1, IntBooleanHashMap.this.getSentinelValues().oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(IntBooleanHashMap.this.keys[i], IntBooleanHashMap.this.getValueAtIndex(i)), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntBooleanPair, ? super P> procedure, P parameter) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, IntBooleanHashMap.this.getSentinelValues().zeroValue), parameter);
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, IntBooleanHashMap.this.getSentinelValues().oneValue), parameter);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntBooleanHashMap.this.keys[i], IntBooleanHashMap.this.getValueAtIndex(i)), parameter);
            }
        }

        public Iterator<IntBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<IntBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntBooleanHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, IntBooleanHashMap.this.getSentinelValues().zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntBooleanHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, IntBooleanHashMap.this.getSentinelValues().oneValue);
                    }
                }
                int[] keys = IntBooleanHashMap.this.keys;
                while (!IntBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntBooleanPair result = PrimitiveTuples.pair(keys[this.position], IntBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean removed = true;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntBooleanHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.removed = false;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntBooleanHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntBooleanHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntBooleanHashMap.this.keys;
            while (!IntBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            IntBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.removed = true;
        }
    }

    private class ValuesCollection
    extends AbstractMutableBooleanValuesMap.AbstractBooleanValuesCollection {
        private ValuesCollection() {
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntBooleanHashMap.this.sentinelValues != null) {
                    if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf(IntBooleanHashMap.this.getSentinelValues().zeroValue));
                        first = false;
                    }
                    if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(IntBooleanHashMap.this.getSentinelValues().oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                    if (!IntBooleanHashMap.this.isNonSentinelAtIndex(i)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(IntBooleanHashMap.this.getValueAtIndex(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public MutableBooleanIterator booleanIterator() {
            return IntBooleanHashMap.this.booleanIterator();
        }

        public boolean remove(boolean item) {
            int oldSize = IntBooleanHashMap.this.size();
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey && item == IntBooleanHashMap.this.getSentinelValues().zeroValue) {
                    IntBooleanHashMap.this.removeKey(0);
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey && item == IntBooleanHashMap.this.getSentinelValues().oneValue) {
                    IntBooleanHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i]) || item != IntBooleanHashMap.this.getValueAtIndex(i)) continue;
                IntBooleanHashMap.this.removeKey(IntBooleanHashMap.this.keys[i]);
            }
            return oldSize != IntBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = IntBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            IntBooleanHashMap retained = IntBooleanHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$f23851cf$1((BooleanSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                IntBooleanHashMap.access$302(IntBooleanHashMap.this, retained.keys);
                IntBooleanHashMap.this.values = retained.values;
                IntBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                IntBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$retainAll$f23851cf$1(BooleanSet sourceSet, int key, boolean value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        @Override
        protected int getKeyAtIndex(int index) {
            return IntBooleanHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return IntBooleanHashMap.this.keys.length;
        }

        @Override
        protected MutableIntKeysMap getOuter() {
            return IntBooleanHashMap.this;
        }

        @Override
        protected AbstractMutableBooleanValuesMap.SentinelValues getSentinelValues() {
            return IntBooleanHashMap.this.sentinelValues;
        }

        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = IntBooleanHashMap.this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntBooleanHashMap retained = IntBooleanHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$be01c4ef$1((IntSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                IntBooleanHashMap.access$302(IntBooleanHashMap.this, retained.keys);
                IntBooleanHashMap.this.values = retained.values;
                IntBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                IntBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public IntSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public MutableIntSet newEmpty() {
            return new IntHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$be01c4ef$1(IntSet sourceSet, int key, boolean value) {
            return sourceSet.contains(key);
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        @Override
        public boolean isEmpty() {
            return IntBooleanHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return IntBooleanHashMap.this.notEmpty();
        }

        @Override
        public int size() {
            return IntBooleanHashMap.this.size();
        }

        @Override
        public boolean contains(int key) {
            return IntBooleanHashMap.this.containsKey(key);
        }

        @Override
        public boolean containsAll(int ... keys) {
            for (int key : keys) {
                if (IntBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(IntIterable source) {
            return source.allSatisfy(IntBooleanHashMap.this::containsKey);
        }

        public IntIterator intIterator() {
            return new UnmodifiableIntIterator((IntIterator)new KeySetIterator());
        }

        public void each(IntProcedure procedure) {
            IntBooleanHashMap.this.forEachKey(procedure);
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntBooleanHashMap.this.sentinelValues != null) {
                    if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntBooleanHashMap.this.keys) {
                    if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(IntPredicate predicate) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int detectIfNone(IntPredicate predicate, int value) {
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        @Override
        public long sum() {
            long result = 0L;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result += 0L;
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    ++result;
                }
            }
            for (int key : IntBooleanHashMap.this.keys) {
                if (!IntBooleanHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        @Override
        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int max = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        @Override
        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            IntIterator iterator = this.intIterator();
            int min = iterator.next();
            while (iterator.hasNext()) {
                int value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        @Override
        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        @Override
        public int[] toArray() {
            int size = IntBooleanHashMap.this.size();
            final int[] result = new int[size];
            IntBooleanHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntBooleanHashMap.this.sentinelValues != null) {
                if (IntBooleanHashMap.this.getSentinelValues().containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntBooleanHashMap.this.getSentinelValues().containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntBooleanHashMap.this.keys.length; ++i) {
                if (!IntBooleanHashMap.isNonSentinel(IntBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        @Override
        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        @Override
        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        @Override
        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }
    }

    private class InternalBooleanIterator
    implements MutableBooleanIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < IntBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntBooleanHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntBooleanHashMap.this.getSentinelValues().zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntBooleanHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntBooleanHashMap.this.getSentinelValues().oneValue;
                }
            }
            int[] keys = IntBooleanHashMap.this.keys;
            while (!IntBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            boolean result = IntBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntBooleanHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

