/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.list.MutableListFactory;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.FastList;

public enum MutableListFactoryImpl implements MutableListFactory
{
    INSTANCE;


    public <T> MutableList<T> empty() {
        return FastList.newList();
    }

    public <T> MutableList<T> of() {
        return this.empty();
    }

    public <T> MutableList<T> with() {
        return this.empty();
    }

    public <T> MutableList<T> of(T ... items) {
        return this.with(items);
    }

    public <T> MutableList<T> with(T ... items) {
        return FastList.newListWith(items);
    }

    public <T> MutableList<T> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public <T> MutableList<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return FastList.newList(capacity);
    }

    public <T> MutableList<T> ofAll(Iterable<? extends T> iterable) {
        return this.withAll(iterable);
    }

    public <T> MutableList<T> withAll(Iterable<? extends T> iterable) {
        return FastList.newList(iterable);
    }

    public <T> MutableList<T> withNValues(int size, Function0<? extends T> factory) {
        return FastList.newWithNValues(size, factory);
    }
}

