/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtCustomerExtractDataActionHandler
extends AbstractBaseActionHandler {
    public BirtCustomerExtractDataActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void __execute() throws Exception {
        boolean flag;
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        String docName = attrBean.getReportDocumentName();
        InputOptions options = new InputOptions();
        options.setOption("request", this.context.getRequest());
        options.setOption("locale", attrBean.getLocale());
        options.setOption("timeZone", attrBean.getTimeZone());
        String extractFormat = ParameterAccessor.getExtractFormat(this.context.getRequest());
        String extractExtension = ParameterAccessor.getExtractExtension(this.context.getRequest());
        if (extractExtension != null) {
            flag = ParameterAccessor.validateExtractExtension(extractExtension);
            if (!flag) {
                AxisFault fault = new AxisFault();
                fault.setFaultReason(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_EXTRACTEXTENSION"));
                throw fault;
            }
            extractFormat = ParameterAccessor.getExtractFormat(extractExtension);
        }
        if (!(flag = ParameterAccessor.validateExtractFormat(extractFormat))) {
            AxisFault fault = new AxisFault();
            fault.setFaultReason(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_EXTRACTFORMAT"));
            throw fault;
        }
        ServletOutputStream out = this.context.getResponse().getOutputStream();
        this.getReportService().extractData(docName, options, (OutputStream)out);
    }

    @Override
    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

