/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.parameter.ScalarParameterFragment;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.ParameterUtility;

public class HiddenParameterFragment
extends ScalarParameterFragment {
    public HiddenParameterFragment(ParameterDefinition parameter) {
        super(parameter);
    }

    @Override
    protected void prepareParameterBean(HttpServletRequest request, IViewerReportService service, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone) throws ReportServiceException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        options.setOption("locale", attrBean.getLocale());
        options.setOption("timeZone", attrBean.getTimeZone());
        Collection selectionList = null;
        ParameterDefinition paramDef = parameterBean.getParameter();
        if (paramDef.getGroup() != null && paramDef.getGroup().cascade()) {
            HashMap paramValues = attrBean.getParameters();
            selectionList = this.getParameterSelectionListForCascadingGroup(attrBean.getReportDesignHandle(request), service, paramValues, options);
            parameterBean.setCascade(true);
        } else {
            selectionList = service.getParameterSelectionList(attrBean.getReportDesignHandle(request), options, this.parameter.getName());
            parameterBean.setCascade(false);
        }
        Object defaultValue = service.getParameterDefaultValue(attrBean.getReportDesignHandle(request), this.parameter.getName(), options);
        for (ParameterSelectionChoice choice : selectionList) {
            if (choice.getValue() == null || !choice.getValue().equals(defaultValue)) continue;
            parameterBean.setDisplayText(choice.getLabel());
        }
        ParameterUtility.makeSelectionList(selectionList, parameterBean, locale, timeZone, true);
    }

    private Collection getParameterSelectionListForCascadingGroup(IViewerReportDesignHandle design, IViewerReportService service, Map paramValues, InputOptions options) throws ReportServiceException {
        ParameterGroupDefinition group = this.parameter.getGroup();
        int index = group.getParameters().indexOf(this.parameter);
        Object[] groupKeys = new Object[index];
        int i = 0;
        while (i < index) {
            ParameterDefinition def = (ParameterDefinition)group.getParameters().get(i);
            groupKeys[i] = paramValues.get(def.getName());
            ++i;
        }
        return service.getSelectionListForCascadingGroup(design, group.getName(), groupKeys, options);
    }
}

