/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import org.dinopolis.gpstool.gpsinput.GPSWaypoint;
import org.dinopolis.gpstool.gpsinput.garmin.GarminDataConverter;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointBase;
import org.dinopolis.gpstool.gpsinput.garmin.GarminWaypointSymbols;

public class GarminWaypointD108
extends GarminWaypointBase {
    public int class_type_;
    public String class_name_;
    public Color color_;
    public String display_options_;
    public short attributes_;
    public int symbol_type_;
    public byte[] subclass_ = new byte[18];
    public float depth_;
    public float distance_;
    public String state_code_ = "";
    public String country_code_ = "";
    public String facility_ = "";
    public String city_ = "";
    public String address_ = "";
    public String cross_road_ = "";
    public int color_index_;
    public int display_index_;
    protected static final byte WAYPOINT_TYPE = 108;
    protected static final String[] DISPLAY_OPTIONS = new String[]{"symbol+name", "symbol", "symbol+comment"};
    protected static Map class_name_map_ = new TreeMap();

    public GarminWaypointD108() {
    }

    public GarminWaypointD108(int[] buffer) {
        this.class_type_ = GarminDataConverter.getGarminByte(buffer, 2);
        this.class_name_ = (String)class_name_map_.get(new Integer(this.class_type_));
        if (this.class_name_ == null) {
            this.class_name_ = "unknown";
        }
        this.color_index_ = GarminDataConverter.getGarminByte(buffer, 3);
        if (this.color_index_ == 255) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = GarminDataConverter.getGarminByte(buffer, 4);
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = GarminDataConverter.getGarminByte(buffer, 5);
        this.symbol_type_ = GarminDataConverter.getGarminWord(buffer, 6);
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.subclass_ = GarminDataConverter.getGarminByteArray(buffer, 7, 18);
        this.latitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 26);
        this.longitude_ = GarminDataConverter.getGarminSemicircleDegrees(buffer, 30);
        this.altitude_ = GarminDataConverter.getGarminFloat(buffer, 34);
        this.depth_ = GarminDataConverter.getGarminFloat(buffer, 38);
        this.distance_ = GarminDataConverter.getGarminFloat(buffer, 42);
        this.state_code_ = GarminDataConverter.getGarminString(buffer, 46, 2).trim();
        this.country_code_ = GarminDataConverter.getGarminString(buffer, 48, 2).trim();
        this.identification_ = GarminDataConverter.getGarminString(buffer, 50, 51);
        int offset = 50 + this.identification_.length() + 1;
        this.comment_ = GarminDataConverter.getGarminString(buffer, offset, 51);
        offset = offset + this.comment_.length() + 1;
        this.facility_ = GarminDataConverter.getGarminString(buffer, offset, 51);
        offset = offset + this.facility_.length() + 1;
        this.city_ = GarminDataConverter.getGarminString(buffer, offset, 51);
        offset = offset + this.city_.length() + 1;
        this.address_ = GarminDataConverter.getGarminString(buffer, offset, 51);
        offset = offset + this.address_.length() + 1;
        this.cross_road_ = GarminDataConverter.getGarminString(buffer, offset, 51);
        offset = offset + this.cross_road_.length() + 1;
    }

    public GarminWaypointD108(GarminPacket pack) {
        this.class_type_ = pack.getNextAsByte();
        this.class_name_ = (String)class_name_map_.get(new Integer(this.class_type_));
        if (this.class_name_ == null) {
            this.class_name_ = "unknown";
        }
        this.color_index_ = pack.getNextAsByte();
        if (this.color_index_ == 255) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = pack.getNextAsByte();
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = pack.getNextAsByte();
        this.symbol_type_ = pack.getNextAsWord();
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        this.subclass_ = pack.getNextAsByteArray(18);
        this.latitude_ = pack.getNextAsSemicircleDegrees();
        this.longitude_ = pack.getNextAsSemicircleDegrees();
        this.altitude_ = pack.getNextAsFloat();
        this.depth_ = pack.getNextAsFloat();
        this.distance_ = pack.getNextAsFloat();
        this.state_code_ = pack.getNextAsString(2).trim();
        this.country_code_ = pack.getNextAsString(2).trim();
        this.identification_ = pack.getNextAsString(51);
        this.comment_ = pack.getNextAsString(51);
        this.facility_ = pack.getNextAsString(31);
        this.city_ = pack.getNextAsString(25);
        this.address_ = pack.getNextAsString(51);
        this.cross_road_ = pack.getNextAsString(51);
    }

    GarminWaypointD108(GPSWaypoint waypoint) {
        this.class_type_ = 0;
        this.class_name_ = (String)class_name_map_.get(new Integer(this.class_type_));
        if (this.class_name_ == null) {
            this.class_name_ = "unknown";
        }
        this.color_index_ = 255;
        if (this.color_index_ == 255) {
            this.color_index_ = 15;
        }
        this.color_ = COLORS[this.color_index_];
        this.display_index_ = 0;
        this.display_options_ = this.display_index_ < DISPLAY_OPTIONS.length ? DISPLAY_OPTIONS[this.display_index_] : "unknown";
        this.attributes_ = (short)96;
        this.symbol_type_ = GarminWaypointSymbols.getSymbolId(waypoint.getSymbolName());
        if (this.symbol_type_ < 0) {
            this.symbol_type_ = 18;
        }
        this.symbol_name_ = GarminWaypointSymbols.getSymbolName(this.symbol_type_);
        for (int i = 0; i < 18; ++i) {
            this.subclass_[i] = i < 6 ? 0 : -1;
        }
        this.latitude_ = waypoint.getLatitude();
        this.longitude_ = waypoint.getLongitude();
        this.altitude_ = waypoint.hasValidAltitude() ? (double)((float)waypoint.getAltitude()) : (double)1.0E25f;
        this.depth_ = 1.0E25f;
        this.distance_ = 0.0f;
        this.state_code_ = "";
        this.country_code_ = "";
        String tmp = waypoint.getIdentification();
        this.identification_ = tmp == null ? "" : tmp;
        tmp = waypoint.getComment();
        this.comment_ = tmp == null ? "" : tmp;
        this.facility_ = "";
        this.city_ = "";
        this.address_ = "";
        this.cross_road_ = "";
    }

    public GarminPacket toGarminPacket(int packet_id) {
        int data_length = 48 + Math.min(this.identification_.length() + 1, 51) + Math.min(this.comment_.length() + 1, 51) + Math.min(this.facility_.length() + 1, 31) + Math.min(this.city_.length() + 1, 25) + Math.min(this.address_.length() + 1, 51) + Math.min(this.cross_road_.length() + 1, 51);
        GarminPacket pack = new GarminPacket(packet_id, data_length);
        pack.setNextAsByte(this.class_type_);
        pack.setNextAsByte(this.color_index_);
        pack.setNextAsByte(this.display_index_);
        pack.setNextAsByte(this.attributes_);
        pack.setNextAsWord(this.symbol_type_);
        pack.setNextAsByteArray(this.subclass_);
        pack.setNextAsSemicircleDegrees(this.latitude_);
        pack.setNextAsSemicircleDegrees(this.longitude_);
        pack.setNextAsFloat((float)this.altitude_);
        pack.setNextAsFloat(this.depth_);
        pack.setNextAsFloat(this.distance_);
        pack.setNextAsString(this.state_code_, 2, false);
        pack.setNextAsString(this.country_code_, 2, false);
        pack.setNextAsString(this.identification_, 51, true);
        pack.setNextAsString(this.comment_, 51, true);
        pack.setNextAsString(this.facility_, 31, true);
        pack.setNextAsString(this.city_, 25, true);
        pack.setNextAsString(this.address_, 51, true);
        pack.setNextAsString(this.cross_road_, 51, true);
        return pack;
    }

    public byte getType() {
        return 108;
    }

    public String getClassName() {
        return this.class_name_;
    }

    public int getClassType() {
        return this.class_type_;
    }

    public Color getColor() {
        return this.color_;
    }

    public String getDisplayOptions() {
        return this.display_options_;
    }

    public short getAttributes() {
        return this.attributes_;
    }

    public float getDepth() {
        return this.depth_;
    }

    public float getDistance() {
        return this.distance_;
    }

    public String getStateCode() {
        return this.state_code_;
    }

    public String getCountryCode() {
        return this.country_code_;
    }

    public String getFacility() {
        return this.facility_;
    }

    public String getCity() {
        return this.city_;
    }

    public String getAddress() {
        return this.address_;
    }

    public String getCrossroad() {
        return this.cross_road_;
    }

    static {
        class_name_map_.put(new Integer(0), "user");
        class_name_map_.put(new Integer(64), "aviation_airport");
        class_name_map_.put(new Integer(65), "aviation_intersection");
        class_name_map_.put(new Integer(66), "aviation_NDB");
        class_name_map_.put(new Integer(67), "aviation_VOR");
        class_name_map_.put(new Integer(68), "aviation_airport_runway");
        class_name_map_.put(new Integer(69), "aviation_airport_intersection");
        class_name_map_.put(new Integer(70), "aviation_airport_NDB");
        class_name_map_.put(new Integer(128), "map_point");
        class_name_map_.put(new Integer(129), "map_area");
        class_name_map_.put(new Integer(130), "map_intersection");
        class_name_map_.put(new Integer(131), "map_address");
        class_name_map_.put(new Integer(132), "map_label");
        class_name_map_.put(new Integer(133), "map_line");
    }
}

