/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput.garmin;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.garmin.GarminPacket;
import org.dinopolis.util.io.Tokenizer;

public class GarminDisplayData {
    int height_;
    int width_;
    int bytes_per_line_;
    int bit_per_pixel_;
    int pixel_per_byte_;
    int bit_mask_;
    BufferedImage image_;
    Graphics graphics_;
    int rotate_image_degrees_;
    Color[] colors_;
    private static Logger logger_ = Logger.getLogger((Class)GarminDisplayData.class);

    public GarminDisplayData() {
    }

    public GarminDisplayData(GarminPacket garmin_packet) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("first display data packet: " + garmin_packet));
        }
        this.bytes_per_line_ = (int)garmin_packet.getLongWord(8);
        this.bit_per_pixel_ = garmin_packet.getByte(12);
        this.width_ = (int)garmin_packet.getLongWord(16);
        this.height_ = (int)garmin_packet.getLongWord(20);
        this.rotate_image_degrees_ = this.guessOrientation(garmin_packet);
        this.image_ = this.rotate_image_degrees_ != 0 && this.rotate_image_degrees_ != 180 ? new BufferedImage(this.height_, this.width_, 1) : new BufferedImage(this.width_, this.height_, 1);
        int num_colors = (int)Math.pow(2.0, this.bit_per_pixel_);
        this.colors_ = new Color[num_colors];
        for (int color_index = 0; color_index < num_colors; ++color_index) {
            if (num_colors == 16) continue;
            int value = garmin_packet.getByte(color_index + 24);
            int grey_value = value * 16;
            this.colors_[color_index] = new Color(grey_value, grey_value, grey_value);
        }
        this.graphics_ = this.image_.createGraphics();
        this.pixel_per_byte_ = 8 / this.bit_per_pixel_;
        this.bit_mask_ = (int)Math.pow(2.0, this.bit_per_pixel_) - 1;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("first display data packet: " + this));
        }
    }

    public void addData(GarminPacket garmin_packet) {
        long data_type;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("next display data packet: " + garmin_packet));
        }
        if ((data_type = garmin_packet.getNextAsLongWord()) == 1L) {
            long byte_offset = garmin_packet.getNextAsLongWord();
            int x = (int)(byte_offset % (long)this.bytes_per_line_) * this.pixel_per_byte_;
            int y = (int)(byte_offset / (long)this.bytes_per_line_);
            int data_bytes_available = garmin_packet.getPacketSize() - 8;
            for (int index_bytes = 0; index_bytes < data_bytes_available; ++index_bytes) {
                short value = garmin_packet.getNextAsByte();
                for (int pixel_per_byte_count = 0; pixel_per_byte_count < this.pixel_per_byte_; ++pixel_per_byte_count) {
                    int pixel_value = value >> pixel_per_byte_count * this.bit_per_pixel_ & this.bit_mask_;
                    this.drawPixel(x, y, pixel_value);
                    ++x;
                }
            }
        } else if (data_type == 2L) {
            long color_index = garmin_packet.getNextAsLongWord() / 3L;
            short blue = garmin_packet.getNextAsByte();
            short green = garmin_packet.getNextAsByte();
            short red = garmin_packet.getNextAsByte();
            this.colors_[(int)color_index] = new Color(red, green, blue);
        }
    }

    protected void drawPixel(int x, int y, int value) {
        this.graphics_.setColor(this.colors_[value]);
        if (this.rotate_image_degrees_ == -90) {
            this.graphics_.drawLine(y, this.width_ - x - 1, y, this.width_ - x - 1);
        } else if (this.rotate_image_degrees_ == 90) {
            this.graphics_.drawLine(this.height_ - y - 1, x, this.height_ - y - 1, x);
        } else {
            this.graphics_.drawLine(x, y, x, y);
        }
    }

    protected int guessOrientation(GarminPacket garmin_packet) {
        int byte5 = garmin_packet.getByte(5);
        int byte8 = garmin_packet.getByte(8);
        if (byte5 == 0 && byte8 == 76) {
            System.err.println("INFO: probably eTrex Legend detected, if orientation of image is wrong, please contact the authors!");
            return -90;
        }
        if (byte5 == 0 && byte8 == 40) {
            System.err.println("INFO: probably eMap legend detected, if orientation of image is wrong, please contact the authors!");
            return -90;
        }
        if (byte5 == 1 && byte8 == 32) {
            System.err.println("INFO: probably eTrex Summit detected, if orientation of image is wrong, please contact the authors!");
            return 90;
        }
        if (byte5 == 0 && byte8 == 8) {
            System.err.println("INFO: probably Geko detected, if orientation of image is wrong, please contact the authors!");
            return 0;
        }
        System.err.println("INFO: no idea which device, please contact the author to help to find out more about the garmin protocol!");
        return 0;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getWidth() {
        return this.width_;
    }

    public BufferedImage getImage() {
        return this.image_;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GarminDisplayData[");
        buffer.append("width=").append(this.width_);
        buffer.append(",height=").append(this.height_);
        buffer.append(",bit per pixel=").append(this.bit_per_pixel_);
        buffer.append(",rotate=").append(this.rotate_image_degrees_);
        buffer.append("]");
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("need to give a filename to read packet data from!");
                return;
            }
            Tokenizer tokenizer = new Tokenizer((InputStream)new FileInputStream(args[0]));
            tokenizer.setDelimiters(" ");
            List tokens = tokenizer.nextLine();
            GarminPacket header = new GarminPacket(69, tokens.size());
            for (int index = 0; index < tokens.size(); ++index) {
                header.put(Integer.parseInt((String)tokens.get(index)));
            }
            GarminDisplayData display_data = new GarminDisplayData(header);
            while (tokenizer.hasNextLine()) {
                tokens = tokenizer.nextLine();
                GarminPacket data = new GarminPacket(69, tokens.size());
                for (int index = 0; index < tokens.size(); ++index) {
                    data.put(Integer.parseInt((String)tokens.get(index)));
                }
                display_data.addData(data);
            }
            BufferedImage image = display_data.getImage();
            FileOutputStream out = new FileOutputStream("image.png");
            ImageIO.write((RenderedImage)image, "PNG", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

