/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;

public class GPSSerialDevice
implements GPSDevice {
    public static final String PORT_NAME_KEY = "port_name";
    public static final String PORT_SPEED_KEY = "port_speed";
    public static final String RAW_DATA_LOG_FILENAME_KEY = "data_logfile";
    protected static final String DEFAULT_PORT_NAME_LINUX = "/dev/ttyS1";
    protected static final String DEFAULT_PORT_NAME_WIN = "COM1";
    protected static final int DEFAULT_PORT_SPEED = 4800;
    protected SerialPort serial_port_;
    String serial_port_name_;
    int serial_port_speed_;
    private static Logger logger_ = Logger.getLogger((Class)GPSSerialDevice.class);

    public void init(Hashtable environment) throws GPSException {
        try {
            this.serial_port_name_ = (String)environment.get(PORT_NAME_KEY);
            if (this.serial_port_name_ == null) {
                this.serial_port_name_ = System.getProperty("os.name").toLowerCase().startsWith("windows") ? DEFAULT_PORT_NAME_WIN : DEFAULT_PORT_NAME_LINUX;
            }
            this.serial_port_speed_ = environment.containsKey(PORT_SPEED_KEY) ? (Integer)environment.get(PORT_SPEED_KEY) : 4800;
        }
        catch (Exception e) {
            throw new GPSException("Invalid environment set for serial connection: " + e.getMessage());
        }
    }

    public void open() throws GPSException {
        try {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("try to connect to port '" + this.serial_port_name_ + "' using " + this.serial_port_speed_ + " baud"));
            }
            CommPortIdentifier port_id = CommPortIdentifier.getPortIdentifier((String)this.serial_port_name_);
            this.serial_port_ = (SerialPort)port_id.open("GpsTool", 2000);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"setting speed and serial params to 8,N,1");
            }
            this.serial_port_.setSerialPortParams(this.serial_port_speed_, 8, 1, 0);
        }
        catch (NoSuchPortException e) {
            throw new GPSException("port '" + this.serial_port_name_ + "' not available.");
        }
        catch (PortInUseException e) {
            throw new GPSException("port '" + this.serial_port_name_ + "' is in use by another application (" + e.currentOwner + ")");
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            throw new GPSException(e.getMessage());
        }
    }

    public void close() throws GPSException {
        if (this.serial_port_ != null) {
            this.serial_port_.close();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.serial_port_ != null) {
            return this.serial_port_.getInputStream();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.serial_port_ != null) {
            return this.serial_port_.getOutputStream();
        }
        return null;
    }

    public void setSerialPortSpeed(int speed) throws IOException {
        try {
            this.serial_port_.setSerialPortParams(speed, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

