/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.gpsinput;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import org.dinopolis.gpstool.gpsinput.GPSRoute;
import org.dinopolis.gpstool.gpsinput.GPSWaypoint;

public class GPSRouteImpl
implements GPSRoute {
    protected Vector route_points_ = new Vector();
    protected String identification_ = null;
    protected String comment_ = null;
    protected Color color_;
    protected boolean display_;
    protected boolean minmax_valid_ = false;
    protected double min_latitude_ = 90.0;
    protected double max_latitude_ = -90.0;
    protected double min_longitude_ = 180.0;
    protected double max_longitude_ = -180.0;
    protected double min_altitude_ = Double.MAX_VALUE;
    protected double max_altitude_ = Double.MIN_VALUE;

    public String getIdentification() {
        return this.identification_;
    }

    public void setIdentification(String identification) {
        this.identification_ = identification;
    }

    public String getComment() {
        return this.comment_;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
    }

    public boolean isDisplayed() {
        return this.display_;
    }

    public void setDisplayed(boolean display) {
        this.display_ = display;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public List getWaypoints() {
        return (List)this.route_points_.clone();
    }

    public void setWaypoints(List routepoints) {
        this.route_points_ = new Vector(routepoints);
        this.minmax_valid_ = false;
    }

    public void addWaypoint(GPSWaypoint routepoint) {
        this.route_points_.add(routepoint);
        this.minmax_valid_ = false;
    }

    public void addWaypoint(int position, GPSWaypoint routepoint) {
        this.route_points_.add(position, routepoint);
        this.minmax_valid_ = false;
    }

    public GPSWaypoint getWaypoint(int position) throws IndexOutOfBoundsException {
        return (GPSWaypoint)this.route_points_.get(position);
    }

    public void removeWaypoint(int position) throws IndexOutOfBoundsException {
        this.route_points_.remove(position);
        this.minmax_valid_ = false;
    }

    public void clear() {
        this.route_points_.clear();
        this.identification_ = "";
        this.comment_ = "";
        this.min_latitude_ = 90.0;
        this.max_latitude_ = -90.0;
        this.min_longitude_ = 180.0;
        this.max_longitude_ = -180.0;
        this.min_altitude_ = Double.MAX_VALUE;
        this.max_altitude_ = Double.MIN_VALUE;
    }

    public int size() {
        return this.route_points_.size();
    }

    public double getMinLatitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.min_latitude_;
    }

    public double getMaxLatitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.max_latitude_;
    }

    public double getMinLongitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.min_longitude_;
    }

    public double getMaxLongitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.max_longitude_;
    }

    public double getMinAltitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.min_altitude_;
    }

    public double getMaxAltitude() {
        if (!this.minmax_valid_) {
            this.calculateMinMax();
        }
        return this.max_altitude_;
    }

    protected void calculateMinMax() {
        this.min_latitude_ = 90.0;
        this.max_latitude_ = -90.0;
        this.min_longitude_ = 180.0;
        this.max_longitude_ = -180.0;
        this.min_altitude_ = Double.MAX_VALUE;
        this.max_altitude_ = Double.MIN_VALUE;
        for (int index = 0; index < this.route_points_.size(); ++index) {
            GPSWaypoint waypoint = (GPSWaypoint)this.route_points_.get(index);
            double value = waypoint.getLatitude();
            this.min_latitude_ = Math.min(value, this.min_latitude_);
            this.max_latitude_ = Math.max(value, this.max_latitude_);
            value = waypoint.getLongitude();
            this.min_longitude_ = Math.min(value, this.min_longitude_);
            this.max_longitude_ = Math.max(value, this.max_longitude_);
            value = waypoint.getAltitude();
            if (value == Double.NaN) continue;
            this.min_altitude_ = Math.min(value, this.min_altitude_);
            this.max_altitude_ = Math.max(value, this.max_altitude_);
        }
        this.minmax_valid_ = true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("GPSRouteImpl[identification=").append(this.identification_).append(",");
        buf.append("route points=").append(this.route_points_.toString()).append("]");
        return buf.toString();
    }
}

