/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CropImageTransform
extends BaseImageTransform<Mat> {
    private int cropTop;
    private int cropLeft;
    private int cropBottom;
    private int cropRight;
    private int x;
    private int y;

    public CropImageTransform(int crop) {
        this(null, crop, crop, crop, crop);
    }

    public CropImageTransform(Random random, int crop) {
        this(random, crop, crop, crop, crop);
    }

    public CropImageTransform(@JsonProperty(value="cropTop") int cropTop, @JsonProperty(value="cropLeft") int cropLeft, @JsonProperty(value="cropBottom") int cropBottom, @JsonProperty(value="cropRight") int cropRight) {
        this(null, cropTop, cropLeft, cropBottom, cropRight);
    }

    public CropImageTransform(Random random, int cropTop, int cropLeft, int cropBottom, int cropRight) {
        super(random);
        this.cropTop = cropTop;
        this.cropLeft = cropLeft;
        this.cropBottom = cropBottom;
        this.cropRight = cropRight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        Mat mat = (Mat)this.converter.convert(image.getFrame());
        int top = random != null ? random.nextInt(this.cropTop + 1) : this.cropTop;
        int left = random != null ? random.nextInt(this.cropLeft + 1) : this.cropLeft;
        int bottom = random != null ? random.nextInt(this.cropBottom + 1) : this.cropBottom;
        int right = random != null ? random.nextInt(this.cropRight + 1) : this.cropRight;
        this.y = Math.min(top, mat.rows() - 1);
        this.x = Math.min(left, mat.cols() - 1);
        int h = Math.max(1, mat.rows() - bottom - this.y);
        int w = Math.max(1, mat.cols() - right - this.x);
        Mat result = mat.apply(new Rect(this.x, this.y, w, h));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }

    public int getCropTop() {
        return this.cropTop;
    }

    public int getCropLeft() {
        return this.cropLeft;
    }

    public int getCropBottom() {
        return this.cropBottom;
    }

    public int getCropRight() {
        return this.cropRight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setCropTop(int cropTop) {
        this.cropTop = cropTop;
    }

    public void setCropLeft(int cropLeft) {
        this.cropLeft = cropLeft;
    }

    public void setCropBottom(int cropBottom) {
        this.cropBottom = cropBottom;
    }

    public void setCropRight(int cropRight) {
        this.cropRight = cropRight;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CropImageTransform)) {
            return false;
        }
        CropImageTransform other = (CropImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCropTop() != other.getCropTop()) {
            return false;
        }
        if (this.getCropLeft() != other.getCropLeft()) {
            return false;
        }
        if (this.getCropBottom() != other.getCropBottom()) {
            return false;
        }
        if (this.getCropRight() != other.getCropRight()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        return this.getY() == other.getY();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CropImageTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCropTop();
        result = result * 59 + this.getCropLeft();
        result = result * 59 + this.getCropBottom();
        result = result * 59 + this.getCropRight();
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        return result;
    }

    @Override
    public String toString() {
        return "CropImageTransform(cropTop=" + this.getCropTop() + ", cropLeft=" + this.getCropLeft() + ", cropBottom=" + this.getCropBottom() + ", cropRight=" + this.getCropRight() + ", x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

