/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpsTrust {
    static HttpsTrust INSTANCE = new HttpsTrust(new SslContext());
    private final SSLSocketFactory socketFactory;
    private final HostnameVerifier hostnameVerifier;

    HttpsTrust(SslContext context) {
        this.socketFactory = this.createSocketFactory(context);
        this.hostnameVerifier = this.createHostnameVerifier();
    }

    void trust(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setSSLSocketFactory(this.socketFactory);
            httpsConnection.setHostnameVerifier(this.hostnameVerifier);
        }
    }

    private SSLSocketFactory createSocketFactory(SslContext context) {
        try {
            return context.newFactory(new AlwaysTrustManager());
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to build SSL factory", e);
        }
    }

    private HostnameVerifier createHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    static class AlwaysTrustManager
    implements X509TrustManager {
        AlwaysTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }

    static class SslContext {
        SslContext() {
        }

        SSLSocketFactory newFactory(TrustManager ... managers) throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, managers, new SecureRandom());
            return context.getSocketFactory();
        }
    }
}

