/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem.internal;

import java.io.File;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.utils.PathUtils;

public class DefaultInputFile
implements InputFile {
    public static final String ATTRIBUTE_COMPONENT_KEY = "CMP_KEY";
    private final String absolutePath;
    private final String path;
    private final Map<String, String> attributes;

    private DefaultInputFile(File file, String path, Map<String, String> attributes) {
        this.absolutePath = PathUtils.canonicalPath(file);
        this.path = FilenameUtils.separatorsToUnix((String)path);
        this.attributes = attributes;
    }

    public static DefaultInputFile create(File file, String path, Map<String, String> attributes) {
        return new DefaultInputFile(file, path, attributes);
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public File file() {
        return new File(this.absolutePath);
    }

    @Override
    public String name() {
        return this.file().getName();
    }

    @Override
    public String type() {
        return this.attribute("TYPE");
    }

    @Override
    public boolean has(String attribute, String value) {
        return StringUtils.equals((String)this.attributes.get(attribute), (String)value);
    }

    @Override
    @CheckForNull
    public String attribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultInputFile other = (DefaultInputFile)o;
        return this.absolutePath.equals(other.absolutePath);
    }

    public int hashCode() {
        return this.absolutePath.hashCode();
    }

    public String toString() {
        return String.format("[%s,%s]", this.path, this.type());
    }
}

