/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue.internal;

import java.io.Serializable;

public class WorkDayDuration
implements Serializable {
    private static final int DAY = 10000;
    private static final int HOUR = 100;
    private static final int MINUTE = 1;
    private int days;
    private int hours;
    private int minutes;

    private WorkDayDuration(int minutes, int hours, int days) {
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
    }

    private WorkDayDuration(long technicalDebtInLong) {
        long time = technicalDebtInLong;
        Long currentTime = time / 10000L;
        if (currentTime > 0L) {
            this.days = currentTime.intValue();
            time -= currentTime * 10000L;
        }
        if ((currentTime = Long.valueOf(time / 100L)) > 0L) {
            this.hours = currentTime.intValue();
            time -= currentTime * 100L;
        }
        if ((currentTime = Long.valueOf(time / 1L)) > 0L) {
            this.minutes = currentTime.intValue();
        }
    }

    public static WorkDayDuration of(int minutes, int hours, int days) {
        return new WorkDayDuration(minutes, hours, days);
    }

    public static WorkDayDuration fromLong(long technicalDebtInLong) {
        return new WorkDayDuration(technicalDebtInLong);
    }

    public long toLong() {
        return this.days * 10000 + this.hours * 100 + this.minutes * 1;
    }

    public long days() {
        return this.days;
    }

    public long hours() {
        return this.hours;
    }

    public long minutes() {
        return this.minutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkDayDuration technicalDebt = (WorkDayDuration)o;
        if (this.days != technicalDebt.days) {
            return false;
        }
        if (this.hours != technicalDebt.hours) {
            return false;
        }
        return this.minutes == technicalDebt.minutes;
    }

    public int hashCode() {
        int result = Integer.valueOf(this.days).hashCode();
        result = 29 * result + Integer.valueOf(this.hours).hashCode();
        result = 27 * result + Integer.valueOf(this.minutes).hashCode();
        return result;
    }
}

