/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.workflow.condition;

import com.google.common.annotations.Beta;
import javax.annotation.Nullable;
import org.sonar.api.config.Settings;
import org.sonar.api.workflow.Review;
import org.sonar.api.workflow.WorkflowContext;
import org.sonar.api.workflow.condition.ProjectPropertyCondition;

@Beta
public final class HasProjectPropertyCondition
extends ProjectPropertyCondition {
    public HasProjectPropertyCondition(String propertyKey) {
        super(propertyKey);
    }

    public boolean doVerify(@Nullable Review review, WorkflowContext context) {
        Settings settings = context.getProjectSettings();
        return settings.hasKey(this.getPropertyKey()) || settings.getDefaultValue(this.getPropertyKey()) != null;
    }

    public String toString() {
        return "Property " + this.getPropertyKey() + " must be set";
    }
}

