/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ServerComponent;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLRuleParser
implements ServerComponent {
    public List<Rule> parse(File file) {
        List<Rule> list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)FileUtils.openInputStream((File)file), "UTF-8");
            list = this.parse(reader);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Fail to load the file: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public List<Rule> parse(InputStream input) {
        List<Rule> list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(input, "UTF-8");
            list = this.parse(reader);
        }
        catch (IOException e) {
            try {
                throw new SonarException("Fail to load the xml stream", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return list;
    }

    public List<Rule> parse(Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            ArrayList<Rule> rules = new ArrayList<Rule>();
            SMInputCursor rulesC = rootC.childElementCursor("rule");
            while (rulesC.getNext() != null) {
                Rule rule = Rule.create();
                rules.add(rule);
                XMLRuleParser.processRule(rule, rulesC);
            }
            return rules;
        }
        catch (XMLStreamException e) {
            throw new SonarException("XML is not valid", e);
        }
    }

    private static void processRule(Rule rule, SMInputCursor ruleC) throws XMLStreamException {
        String priorityAttribute;
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank((String)keyAttribute)) {
            rule.setKey(StringUtils.trim((String)keyAttribute));
        }
        if (StringUtils.isNotBlank((String)(priorityAttribute = ruleC.getAttrValue("priority")))) {
            rule.setSeverity(RulePriority.valueOf(StringUtils.trim((String)priorityAttribute)));
        }
        SMInputCursor cursor = ruleC.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase((String)"name", (String)nodeName)) {
                rule.setName(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)nodeName)) {
                rule.setDescription(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"key", (String)nodeName)) {
                rule.setKey(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"configKey", (String)nodeName)) {
                rule.setConfigKey(StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"priority", (String)nodeName)) {
                rule.setSeverity(RulePriority.valueOf(StringUtils.trim((String)cursor.collectDescendantText(false))));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"cardinality", (String)nodeName)) {
                rule.setCardinality(Cardinality.valueOf((String)StringUtils.trim((String)cursor.collectDescendantText(false))));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"param", (String)nodeName)) continue;
            XMLRuleParser.processParameter(rule, cursor);
        }
        if (StringUtils.isEmpty((String)rule.getKey())) {
            throw new SonarException("Node <key> is missing in <rule>");
        }
    }

    private static void processParameter(Rule rule, SMInputCursor ruleC) throws XMLStreamException {
        String typeAttribute;
        RuleParam param = rule.createParameter();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank((String)keyAttribute)) {
            param.setKey(StringUtils.trim((String)keyAttribute));
        }
        if (StringUtils.isNotBlank((String)(typeAttribute = ruleC.getAttrValue("type")))) {
            param.setType(StringUtils.trim((String)typeAttribute));
        }
        SMInputCursor paramC = ruleC.childElementCursor();
        while (paramC.getNext() != null) {
            String propNodeName = paramC.getLocalName();
            String propText = StringUtils.trim((String)paramC.collectDescendantText(false));
            if (StringUtils.equalsIgnoreCase((String)"key", (String)propNodeName)) {
                param.setKey(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)propNodeName)) {
                param.setDescription(propText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"type", (String)propNodeName)) {
                param.setType(propText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"defaultValue", (String)propNodeName)) continue;
            param.setDefaultValue(propText);
        }
        if (StringUtils.isEmpty((String)param.getKey())) {
            throw new SonarException("Node <key> is missing in <param>");
        }
    }
}

