/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sonar.api.utils.SonarException;

public final class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final ThreadSafeDateFormat dateFormat = new ThreadSafeDateFormat("yyyy-MM-dd");
    private static final ThreadSafeDateFormat dateTimeFormat = new ThreadSafeDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    private DateUtils() {
    }

    public static String formatDate(Date d) {
        return dateFormat.format(d);
    }

    public static String formatDateTime(Date d) {
        return dateTimeFormat.format(d);
    }

    public static Date parseDate(String s) {
        try {
            return dateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new SonarException("The date '" + s + "' does not respect format '" + DATE_FORMAT + "'", e);
        }
    }

    public static Date parseDateTime(String s) {
        try {
            return dateTimeFormat.parse(s);
        }
        catch (ParseException e) {
            throw new SonarException("The date '" + s + "' does not respect format '" + DATETIME_FORMAT + "'", e);
        }
    }

    static class ThreadSafeDateFormat
    extends DateFormat {
        private final String format;
        private final transient ThreadLocal cache = new ThreadLocal(){

            public Object get() {
                SoftReference<SimpleDateFormat> softRef = (SoftReference<SimpleDateFormat>)super.get();
                if (softRef == null || ((Reference)softRef).get() == null) {
                    softRef = new SoftReference<SimpleDateFormat>(new SimpleDateFormat(ThreadSafeDateFormat.this.format));
                    super.set(softRef);
                }
                return softRef;
            }
        };

        ThreadSafeDateFormat(String format) {
            this.format = format;
        }

        private DateFormat getDateFormat() {
            return (DateFormat)((Reference)this.cache.get()).get();
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.getDateFormat().format(date, toAppendTo, fieldPosition);
        }

        public Date parse(String source, ParsePosition pos) {
            return this.getDateFormat().parse(source, pos);
        }
    }
}

