/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.qualitymodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.sonar.api.qualitymodel.CharacteristicProperty;
import org.sonar.api.qualitymodel.Model;
import org.sonar.api.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="characteristics")
public final class Characteristic
implements Comparable<Characteristic> {
    public static final int ROOT_DEPTH = 1;
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Column(name="kee", nullable=true, length=100)
    private String key;
    @Column(name="name", nullable=true, length=100)
    private String name;
    @Column(name="depth")
    private int depth = 1;
    @Column(name="characteristic_order")
    private int order = 0;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="quality_model_id")
    private Model model;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id")
    private Rule rule;
    @Column(name="description", nullable=true, length=4000)
    private String description;
    @Column(name="enabled", updatable=true, nullable=true)
    private Boolean enabled = Boolean.TRUE;
    @ManyToMany
    @JoinTable(name="characteristic_edges", joinColumns={@JoinColumn(name="child_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="parent_id", referencedColumnName="id")})
    private List<Characteristic> parents = Lists.newArrayList();
    @Sort(type=SortType.NATURAL)
    @ManyToMany(mappedBy="parents", cascade={CascadeType.ALL})
    private List<Characteristic> children = Lists.newArrayList();
    @OneToMany(mappedBy="characteristic", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<CharacteristicProperty> properties = Lists.newArrayList();

    Characteristic() {
    }

    public Integer getId() {
        return this.id;
    }

    Characteristic setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Characteristic setKey(String s) {
        this.key = StringUtils.trimToNull((String)s);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Characteristic setName(String s) {
        return this.setName(s, false);
    }

    public Characteristic setName(String s, boolean asKey) {
        this.name = StringUtils.trimToNull((String)s);
        if (asKey) {
            this.key = StringUtils.upperCase((String)this.name);
            this.key = StringUtils.replaceChars((String)this.key, (char)' ', (char)'_');
        }
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    Characteristic setModel(Model model) {
        this.model = model;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean hasRule() {
        return this.rule != null;
    }

    public Characteristic setRule(Rule r) {
        this.rule = r;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Characteristic setEnabled(Boolean b) {
        this.enabled = b;
        return this;
    }

    public Characteristic addChildren(Characteristic ... list) {
        if (list != null) {
            for (Characteristic c : list) {
                this.addChild(c);
            }
        }
        return this;
    }

    public Characteristic addChild(Characteristic child) {
        Characteristic.propagateDepth(child, this.depth + 1);
        child.addParents(this);
        child.setModel(this.model);
        this.children.add(child);
        return this;
    }

    Characteristic removeChild(Characteristic child) {
        this.children.remove(child);
        return this;
    }

    private static void propagateDepth(Characteristic characteristic, int depth) {
        characteristic.setDepth(depth);
        for (Characteristic child : characteristic.getChildren()) {
            Characteristic.propagateDepth(child, depth + 1);
        }
    }

    Characteristic addParents(Characteristic ... pc) {
        if (pc != null) {
            Collections.addAll(this.parents, pc);
        }
        return this;
    }

    public List<Characteristic> getParents() {
        return this.parents;
    }

    public Characteristic getParent(String name) {
        for (Characteristic parent : this.parents) {
            if (!StringUtils.equals((String)parent.getName(), (String)name)) continue;
            return parent;
        }
        return null;
    }

    public List<Characteristic> getChildren() {
        return this.getChildren(true);
    }

    public List<Characteristic> getChildren(boolean onlyEnabled) {
        if (onlyEnabled) {
            return this.children;
        }
        ArrayList result = Lists.newArrayList();
        for (Characteristic child : this.children) {
            if (!child.getEnabled().booleanValue()) continue;
            result.add(child);
        }
        return result;
    }

    public Characteristic getChild(String name) {
        for (Characteristic child : this.children) {
            if (!StringUtils.equals((String)child.getName(), (String)name)) continue;
            return child;
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRoot() {
        return this.depth == 1;
    }

    Characteristic setDepth(int i) {
        this.depth = i;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    Characteristic setOrder(int i) {
        this.order = i;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Characteristic setDescription(String s) {
        this.description = s;
        return this;
    }

    public CharacteristicProperty setProperty(String key, String value) {
        return this.addProperty(CharacteristicProperty.create(key).setTextValue(value));
    }

    public CharacteristicProperty setProperty(String key, Double value) {
        return this.addProperty(CharacteristicProperty.create(key).setValue(value));
    }

    public CharacteristicProperty addProperty(CharacteristicProperty property) {
        property.setCharacteristic(this);
        this.properties.add(property);
        return property;
    }

    public CharacteristicProperty getProperty(String key) {
        for (CharacteristicProperty property : this.properties) {
            if (!StringUtils.equals((String)key, (String)property.getKey())) continue;
            return property;
        }
        return null;
    }

    public String getPropertyTextValue(String key, String defaultValue) {
        CharacteristicProperty property = this.getProperty(key);
        String value = property != null ? property.getTextValue() : null;
        return StringUtils.defaultIfEmpty((String)value, (String)defaultValue);
    }

    public Double getPropertyValue(String key, Double defaultValue) {
        CharacteristicProperty property = this.getProperty(key);
        Double value = property != null ? property.getValue() : null;
        return value == null ? defaultValue : value;
    }

    public List<CharacteristicProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Characteristic that = (Characteristic)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.rule != null ? !this.rule.equals(that.rule) : that.rule != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("name", (Object)this.name).append("rule", (Object)this.rule).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Characteristic o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.order - o.order;
    }

    public static Characteristic create() {
        return new Characteristic();
    }

    public static Characteristic createByName(String name) {
        return new Characteristic().setName(name, true);
    }

    public static Characteristic createByKey(String key, String name) {
        return new Characteristic().setKey(key).setName(name, false);
    }

    public static Characteristic createByRule(Rule rule) {
        return new Characteristic().setRule(rule);
    }
}

