/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Beta
@Immutable
public final class ResourceType {
    private final String qualifier;
    private final String iconPath;
    private final boolean hasSourceCode;
    private final boolean availableForFilters;

    public static Builder builder(String qualifier) {
        Preconditions.checkNotNull((Object)qualifier);
        Preconditions.checkArgument((qualifier.length() <= 10 ? 1 : 0) != 0, (Object)"Qualifier is limited to 10 characters");
        return new Builder(qualifier);
    }

    private ResourceType(Builder builder) {
        this.qualifier = builder.qualifier;
        this.iconPath = builder.iconPath;
        this.availableForFilters = builder.availableForFilters;
        this.hasSourceCode = builder.hasSourceCode;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public boolean isAvailableForFilters() {
        return this.availableForFilters;
    }

    public boolean hasSourceCode() {
        return this.hasSourceCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return this.qualifier.equals(that.qualifier);
    }

    public int hashCode() {
        return this.qualifier.hashCode();
    }

    public static class Builder {
        private String qualifier;
        private String iconPath;
        private boolean availableForFilters = false;
        private boolean hasSourceCode = false;

        public Builder(String qualifier) {
            this.qualifier = qualifier;
        }

        public Builder setIconPath(@Nullable String iconPath) {
            this.iconPath = iconPath;
            return this;
        }

        public Builder availableForFilters() {
            this.availableForFilters = true;
            return this;
        }

        public Builder hasSourceCode() {
            this.hasSourceCode = true;
            return this;
        }

        public ResourceType build() {
            if (Strings.isNullOrEmpty((String)this.iconPath)) {
                this.iconPath = "/images/q/" + this.qualifier + ".png";
            }
            return new ResourceType(this);
        }
    }
}

